/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.shibboleth.utilities.java.support.collection.LazyList;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.saml.common.AbstractSignableSAMLObject;
import org.opensaml.saml.saml2.common.Extensions;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;

public abstract class RoleDescriptorImpl
extends AbstractSignableSAMLObject
implements RoleDescriptor {
    private String id;
    private DateTime validUntil;
    private Long cacheDuration;
    private final List<String> supportedProtocols;
    private String errorURL;
    private Extensions extensions;
    private Organization organization;
    private final AttributeMap unknownAttributes = new AttributeMap((XMLObject)this);
    private final XMLObjectChildrenList<ContactPerson> contactPersons;
    private final XMLObjectChildrenList<KeyDescriptor> keyDescriptors;

    protected RoleDescriptorImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
        this.supportedProtocols = new LazyList();
        this.contactPersons = new XMLObjectChildrenList((XMLObject)this);
        this.keyDescriptors = new XMLObjectChildrenList((XMLObject)this);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String newID) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newID);
        this.registerOwnID(oldID, this.id);
    }

    public boolean isValid() {
        if (null == this.validUntil) {
            return true;
        }
        DateTime now = new DateTime();
        return now.isBefore((ReadableInstant)this.validUntil);
    }

    public DateTime getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(DateTime validUntil) {
        this.validUntil = this.prepareForAssignment(this.validUntil, validUntil);
    }

    public Long getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(Long duration) {
        this.cacheDuration = (Long)this.prepareForAssignment(this.cacheDuration, duration);
    }

    public List<String> getSupportedProtocols() {
        return Collections.unmodifiableList(this.supportedProtocols);
    }

    public boolean isSupportedProtocol(String protocol) {
        return this.supportedProtocols.contains(protocol);
    }

    public void addSupportedProtocol(String protocol) {
        if ((protocol = StringSupport.trimOrNull((String)protocol)) != null && !this.supportedProtocols.contains(protocol)) {
            this.releaseThisandParentDOM();
            this.supportedProtocols.add(protocol);
        }
    }

    public void removeSupportedProtocol(String protocol) {
        if ((protocol = StringSupport.trimOrNull((String)protocol)) != null && this.supportedProtocols.contains(protocol)) {
            this.releaseThisandParentDOM();
            this.supportedProtocols.remove(protocol);
        }
    }

    public void removeSupportedProtocols(Collection<String> protocols) {
        for (String protocol : protocols) {
            this.removeSupportedProtocol(protocol);
        }
    }

    public void removeAllSupportedProtocols() {
        this.supportedProtocols.clear();
    }

    public String getErrorURL() {
        return this.errorURL;
    }

    public void setErrorURL(String errorURL) {
        this.errorURL = this.prepareForAssignment(this.errorURL, errorURL);
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Extensions extensions) throws IllegalArgumentException {
        this.extensions = (Extensions)this.prepareForAssignment((XMLObject)this.extensions, (XMLObject)extensions);
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) throws IllegalArgumentException {
        this.organization = (Organization)this.prepareForAssignment((XMLObject)this.organization, (XMLObject)organization);
    }

    public List<ContactPerson> getContactPersons() {
        return this.contactPersons;
    }

    public List<KeyDescriptor> getKeyDescriptors() {
        return this.keyDescriptors;
    }

    public AttributeMap getUnknownAttributes() {
        return this.unknownAttributes;
    }

    public String getSignatureReferenceID() {
        return this.id;
    }

    public List<XMLObject> getOrderedChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        if (this.getSignature() != null) {
            children.add(this.getSignature());
        }
        if (this.extensions != null) {
            children.add(this.getExtensions());
        }
        children.addAll(this.getKeyDescriptors());
        if (this.organization != null) {
            children.add(this.getOrganization());
        }
        children.addAll(this.getContactPersons());
        return Collections.unmodifiableList(children);
    }
}

