/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLConsentContext;
import org.opensaml.saml.saml2.core.StatusResponseType;

public class AddConsentToResponseHandler
extends AbstractMessageHandler<StatusResponseType> {
    @Nonnull
    private Function<MessageContext<StatusResponseType>, SAMLConsentContext> consentContextStrategy = new ChildContextLookup(SAMLConsentContext.class);

    public synchronized void setConsentContextLookupStrategy(@Nonnull Function<MessageContext<StatusResponseType>, SAMLConsentContext> strategy) {
        this.consentContextStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLConsentContext lookup strategy cannot be null");
    }

    protected void doInvoke(@Nonnull MessageContext<StatusResponseType> messageContext) throws MessageHandlerException {
        StatusResponseType response = (StatusResponseType)messageContext.getMessage();
        if (response == null) {
            throw new MessageHandlerException("Response was not found");
        }
        SAMLConsentContext consentContext = (SAMLConsentContext)this.consentContextStrategy.apply(messageContext);
        if (consentContext == null || consentContext.getConsent() == null) {
            throw new MessageHandlerException("Consent value not found");
        }
        response.setConsent(consentContext.getConsent());
    }
}

