/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;

public class NodeProcessingMetadataFilter
extends AbstractInitializableComponent
implements MetadataFilter {
    private List<MetadataNodeProcessor> processors;

    @NonnullAfterInit
    public List<MetadataNodeProcessor> getNodeProcessors() {
        return this.processors;
    }

    public void setNodeProcessors(@Nullable List<MetadataNodeProcessor> newProcessors) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        if (newProcessors == null || newProcessors.isEmpty()) {
            this.processors = Collections.emptyList();
            return;
        }
        this.processors = Collections.unmodifiableList(newProcessors);
    }

    @Nullable
    public XMLObject filter(@Nullable XMLObject metadata) throws FilterException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (metadata == null) {
            return null;
        }
        this.processNode(metadata);
        return metadata;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.processors == null) {
            this.processors = Collections.emptyList();
        }
    }

    protected void doDestroy() {
        this.processors = null;
        super.doDestroy();
    }

    protected void processNode(XMLObject node) throws FilterException {
        for (MetadataNodeProcessor processor : this.getNodeProcessors()) {
            processor.process(node);
        }
        List children = node.getOrderedChildren();
        if (children != null) {
            for (XMLObject child : node.getOrderedChildren()) {
                if (child == null) continue;
                this.processNode(child);
            }
        }
    }
}

