/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.saml.common.binding.AbstractEndpointResolver;
import org.opensaml.saml.criterion.BindingCriterion;
import org.opensaml.saml.criterion.EndpointCriterion;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IndexedEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEndpointResolver<EndpointType extends Endpoint>
extends AbstractEndpointResolver<EndpointType> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultEndpointResolver.class);

    protected boolean doCheckEndpoint(@Nonnull CriteriaSet criteria, @Nonnull EndpointType endpoint) {
        BindingCriterion bindingCriterion = (BindingCriterion)criteria.get(BindingCriterion.class);
        if (bindingCriterion != null && !this.checkBindingCriterion(bindingCriterion, endpoint)) {
            return false;
        }
        EndpointCriterion epCriterion = (EndpointCriterion)criteria.get(EndpointCriterion.class);
        return epCriterion == null || this.checkEndpointCriterion(epCriterion, endpoint);
    }

    private boolean checkBindingCriterion(@Nonnull BindingCriterion bindings, @Nonnull EndpointType endpoint) {
        if (endpoint.getBinding() != null && !bindings.getBindings().contains(endpoint.getBinding())) {
            this.log.debug("{} Candidate endpoint binding {} not permitted by input criteria", (Object)this.getLogPrefix(), (Object)endpoint.getBinding());
            return false;
        }
        return true;
    }

    private boolean checkEndpointCriterion(@Nonnull EndpointCriterion<EndpointType> comparison, @Nonnull EndpointType endpoint) {
        Endpoint comparisonEndpoint = comparison.getEndpoint();
        if (comparisonEndpoint.getBinding() != null && !Objects.equal((Object)comparisonEndpoint.getBinding(), (Object)endpoint.getBinding())) {
            this.log.debug("{} Candidate endpoint binding did not match {}", (Object)this.getLogPrefix(), (Object)comparisonEndpoint.getBinding());
            return false;
        }
        if (comparisonEndpoint.getLocation() != null && !Objects.equal((Object)comparisonEndpoint.getLocation(), (Object)endpoint.getLocation()) && !Objects.equal((Object)comparisonEndpoint.getLocation(), (Object)endpoint.getResponseLocation())) {
            this.log.debug("{} Candidate endpoint location did not match {}", (Object)this.getLogPrefix(), (Object)comparisonEndpoint.getLocation());
            return false;
        }
        if (comparisonEndpoint instanceof IndexedEndpoint && ((IndexedEndpoint)comparisonEndpoint).getIndex() != null) {
            if (!(endpoint instanceof IndexedEndpoint)) {
                this.log.debug("{} Candidate endpoint was not indexed, so did not match", (Object)this.getLogPrefix());
                return false;
            }
            if (!Objects.equal((Object)((IndexedEndpoint)comparisonEndpoint).getIndex(), (Object)((IndexedEndpoint)endpoint).getIndex())) {
                this.log.debug("{} Candidate endpoint index did not match {}", (Object)this.getLogPrefix(), (Object)((IndexedEndpoint)comparisonEndpoint).getIndex());
                return false;
            }
        }
        return true;
    }
}

