/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.security.impl;

import com.google.common.base.Predicate;
import java.security.Key;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.saml.security.impl.SAMLMDCredentialContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.impl.BasicEncryptionParametersResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLMetadataEncryptionParametersResolver
extends BasicEncryptionParametersResolver {
    private Logger log = LoggerFactory.getLogger(SAMLMetadataEncryptionParametersResolver.class);
    private MetadataCredentialResolver credentialResolver;

    public SAMLMetadataEncryptionParametersResolver(@Nonnull MetadataCredentialResolver resolver) {
        this.credentialResolver = (MetadataCredentialResolver)((Object)Constraint.isNotNull((Object)((Object)resolver), (String)"MetadataCredentialResoler may not be null"));
    }

    @Nonnull
    protected MetadataCredentialResolver getMetadataCredentialResolver() {
        return this.credentialResolver;
    }

    protected void resolveAndPopulateCredentialsAndAlgorithms(@Nonnull EncryptionParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate) {
        CriteriaSet mdCredResolverCriteria = new CriteriaSet();
        mdCredResolverCriteria.addAll((Collection)criteria);
        mdCredResolverCriteria.add((Object)new UsageCriterion(UsageType.ENCRYPTION), true);
        try {
            for (Credential keyTransportCredential : this.getMetadataCredentialResolver().resolve(mdCredResolverCriteria)) {
                SAMLMDCredentialContext metadataCredContext;
                String dataEncryptionAlgorithm;
                String keyTransportAlgorithm;
                if (this.log.isTraceEnabled()) {
                    Key key = CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential);
                    this.log.trace("Evaluating key transport encryption credential from SAML metadata of type: {}", (Object)(key != null ? key.getAlgorithm() : "n/a"));
                }
                if ((keyTransportAlgorithm = this.resolveKeyTransportAlgorithm(keyTransportCredential, criteria, whitelistBlacklistPredicate, dataEncryptionAlgorithm = this.resolveDataEncryptionAlgorithm(criteria, whitelistBlacklistPredicate, metadataCredContext = (SAMLMDCredentialContext)keyTransportCredential.getCredentialContextSet().get(SAMLMDCredentialContext.class)), metadataCredContext)) == null) {
                    this.log.debug("Unable to resolve key transport algorithm for credential with key type '{}', considering other credentials", (Object)CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential).getAlgorithm());
                    continue;
                }
                params.setKeyTransportEncryptionCredential(keyTransportCredential);
                params.setKeyTransportEncryptionAlgorithm(keyTransportAlgorithm);
                params.setDataEncryptionAlgorithm(dataEncryptionAlgorithm);
                this.processDataEncryptionCredentialAutoGeneration(params);
                return;
            }
        }
        catch (ResolverException e) {
            this.log.warn("Problem resolving credentials from metadata, falling back to local configuration", (Throwable)e);
        }
        this.log.debug("Could not resolve encryption parameters based on SAML metadata, falling back to locally configured credentials and algorithms");
        super.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, whitelistBlacklistPredicate);
    }

    @Nullable
    protected String resolveKeyTransportAlgorithm(@Nonnull Credential keyTransportCredential, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate, @Nullable String dataEncryptionAlgorithm, @Nullable SAMLMDCredentialContext metadataCredContext) {
        if (metadataCredContext != null) {
            for (EncryptionMethod encryptionMethod : metadataCredContext.getEncryptionMethods()) {
                String algorithm = encryptionMethod.getAlgorithm();
                this.log.trace("Evaluating SAML metadata EncryptionMethod algorithm for key transport: {}", (Object)algorithm);
                if (!this.isKeyTransportAlgorithm(algorithm) || !whitelistBlacklistPredicate.apply((Object)algorithm) || !this.getAlgorithmRuntimeSupportedPredicate().apply((Object)algorithm) || !this.credentialSupportsEncryptionMethod(keyTransportCredential, encryptionMethod)) continue;
                this.log.debug("Resolved key transport algorithm URI from SAML metadata EncryptionMethod: {}", (Object)algorithm);
                return algorithm;
            }
        }
        this.log.debug("Could not resolve key transport algorithm based on SAML metadata, falling back to locally configured algorithms");
        return super.resolveKeyTransportAlgorithm(keyTransportCredential, criteria, whitelistBlacklistPredicate, dataEncryptionAlgorithm);
    }

    @Nullable
    protected String resolveDataEncryptionAlgorithm(@Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate, @Nullable SAMLMDCredentialContext metadataCredContext) {
        if (metadataCredContext != null) {
            for (EncryptionMethod encryptionMethod : metadataCredContext.getEncryptionMethods()) {
                String algorithm = encryptionMethod.getAlgorithm();
                this.log.trace("Evaluating SAML metadata EncryptionMethod algorithm for data encryption: {}", (Object)algorithm);
                if (!this.isDataEncryptionAlgorithm(algorithm) || !whitelistBlacklistPredicate.apply((Object)algorithm) || !this.getAlgorithmRuntimeSupportedPredicate().apply((Object)algorithm)) continue;
                this.log.debug("Resolved data encryption algorithm URI from SAML metadata EncryptionMethod: {}", (Object)algorithm);
                return algorithm;
            }
        }
        this.log.debug("Could not resolve data encryption algorithm based on SAML metadata, falling back to locally configured algorithms");
        return super.resolveDataEncryptionAlgorithm(null, criteria, whitelistBlacklistPredicate);
    }

    protected boolean credentialSupportsEncryptionMethod(@Nonnull Credential credential, @Nonnull @NotEmpty EncryptionMethod encryptionMethod) {
        if (!this.credentialSupportsAlgorithm(credential, encryptionMethod.getAlgorithm())) {
            return false;
        }
        if (encryptionMethod.getKeySize() != null && encryptionMethod.getKeySize().getValue() != null) {
            Key encryptionKey = CredentialSupport.extractEncryptionKey((Credential)credential);
            if (encryptionKey == null) {
                this.log.warn("Could not extract encryption key from credential. Failing evaluation");
                return false;
            }
            Integer keyLength = KeySupport.getKeyLength((Key)encryptionKey);
            if (keyLength == null) {
                this.log.warn("Could not determine key length of candidate encryption credential. Failing evaluation");
                return false;
            }
            if (!keyLength.equals(encryptionMethod.getKeySize().getValue())) {
                return false;
            }
        }
        return true;
    }
}

