/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.saml.common.AbstractSignableSAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.Advice;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.AuthorizationDecisionStatement;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.Statement;
import org.opensaml.saml.saml1.core.SubjectStatement;

public class AssertionImpl
extends AbstractSignableSAMLObject
implements Assertion {
    private String id;
    private SAMLVersion version;
    private String issuer;
    private DateTime issueInstant;
    private Conditions conditions;
    private Advice advice;
    private final IndexedXMLObjectChildrenList<Statement> statements = new IndexedXMLObjectChildrenList((XMLObject)this);

    protected AssertionImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
        this.version = SAMLVersion.VERSION_11;
    }

    public int getMajorVersion() {
        return this.version.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.version.getMinorVersion();
    }

    public void setVersion(SAMLVersion newVersion) {
        this.version = (SAMLVersion)this.prepareForAssignment(this.version, newVersion);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, id);
        this.registerOwnID(oldID, this.id);
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = this.prepareForAssignment(this.issuer, issuer);
    }

    public DateTime getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(DateTime issueInstant) {
        this.issueInstant = this.prepareForAssignment(this.issueInstant, issueInstant);
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) throws IllegalArgumentException {
        this.conditions = (Conditions)this.prepareForAssignment((XMLObject)this.conditions, (XMLObject)conditions);
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public void setAdvice(Advice advice) throws IllegalArgumentException {
        this.advice = (Advice)this.prepareForAssignment((XMLObject)this.advice, (XMLObject)advice);
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public List<Statement> getStatements(QName typeOrName) {
        return this.statements.subList(typeOrName);
    }

    public List<SubjectStatement> getSubjectStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectStatement");
        return this.statements.subList(statementQName);
    }

    public List<AuthenticationStatement> getAuthenticationStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement");
        return this.statements.subList(statementQName);
    }

    public List<AuthorizationDecisionStatement> getAuthorizationDecisionStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorizationDecisionStatement");
        return this.statements.subList(statementQName);
    }

    public List<AttributeStatement> getAttributeStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement");
        return this.statements.subList(statementQName);
    }

    public String getSignatureReferenceID() {
        return this.id;
    }

    public List<XMLObject> getOrderedChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        if (this.conditions != null) {
            children.add(this.conditions);
        }
        if (this.advice != null) {
            children.add(this.advice);
        }
        children.addAll((Collection<Object>)this.statements);
        if (this.getSignature() != null) {
            children.add(this.getSignature());
        }
        if (children.size() == 0) {
            return null;
        }
        return Collections.unmodifiableList(children);
    }
}

