/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Subject;
import org.slf4j.Logger;

public final class SAML2ObjectSupport {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(SAML2ObjectSupport.class);

    private SAML2ObjectSupport() {
    }

    public static boolean areNameIDFormatsEquivalent(@Nullable String format1, @Nullable String format2) {
        return Objects.equals(format1 != null ? format1 : "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", format2 != null ? format2 : "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
    }

    public static boolean areNameIDsEquivalent(@Nonnull NameID name1, @Nonnull NameID name2) {
        return SAML2ObjectSupport.areNameIDFormatsEquivalent(name1.getFormat(), name2.getFormat()) && Objects.equals(name1.getValue(), name2.getValue()) && Objects.equals(name1.getNameQualifier(), name2.getNameQualifier()) && Objects.equals(name1.getSPNameQualifier(), name2.getSPNameQualifier());
    }

    public static boolean areNameIDsEquivalent(@Nonnull NameID name1, @Nonnull NameID name2, @Nullable String assertingParty, @Nullable String relyingParty) {
        if (!SAML2ObjectSupport.areNameIDFormatsEquivalent(name1.getFormat(), name2.getFormat()) || !Objects.equals(name1.getValue(), name2.getValue())) {
            return false;
        }
        String name1qual = name1.getNameQualifier();
        String name2qual = name2.getNameQualifier();
        if (name1qual == null) {
            name1qual = assertingParty;
        }
        if (name2qual == null) {
            name2qual = assertingParty;
        }
        if (!Objects.equals(name1qual, name2qual)) {
            return false;
        }
        name1qual = name1.getSPNameQualifier();
        name2qual = name2.getSPNameQualifier();
        if (name1qual == null) {
            name1qual = relyingParty;
        }
        if (name2qual == null) {
            name2qual = relyingParty;
        }
        return Objects.equals(name1qual, name2qual);
    }

    public static boolean matchSubject(@Nonnull Subject target, @Nonnull Subject control) {
        return SAML2ObjectSupport.matchSubject(target, control, true);
    }

    public static boolean matchSubject(@Nonnull Subject target, @Nonnull Subject control, boolean processConfirmation) {
        Constraint.isNotNull((Object)target, (String)"Target Subject was null");
        Constraint.isNotNull((Object)control, (String)"Control Subject was null");
        if (processConfirmation && !target.getSubjectConfirmations().isEmpty()) {
            LOG.warn("Target Subject contains SubjectConfirmation, currently not supported and eval is skipped");
        }
        if (target.getEncryptedID() != null || control.getEncryptedID() != null) {
            throw new IllegalArgumentException("Saw EncryptedID in Subject, matching not supported");
        }
        if (target.getBaseID() != null || control.getBaseID() != null) {
            throw new IllegalArgumentException("Saw BaseID in Subject, matching not supported");
        }
        NameID targetNameID = target.getNameID();
        NameID controlNameID = control.getNameID();
        if (targetNameID == null && controlNameID == null) {
            LOG.debug("Both target and control NameIDs are null, trivially match");
            return true;
        }
        if (targetNameID == null || controlNameID == null) {
            LOG.debug("One NameID is null ({}), the other is not, trivially do not match", (Object)(targetNameID == null ? "target" : "control"));
            return false;
        }
        return SAML2ObjectSupport.areNameIDsEquivalent(targetNameID, controlNameID);
    }
}

