/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.messaging;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.servlet.HttpServletSupport;
import org.opensaml.saml.saml2.assertion.messaging.AssertionValidationNetworkInformationSupplier;
import org.opensaml.security.SecurityException;
import org.opensaml.security.messaging.ServletRequestX509CredentialAdapter;

public class HttpServletRequestNetworkInformationSupplier
implements AssertionValidationNetworkInformationSupplier {
    @Nonnull
    private HttpServletRequest servletRequest;

    public HttpServletRequestNetworkInformationSupplier(@Nonnull HttpServletRequest request) {
        this.servletRequest = (HttpServletRequest)Constraint.isNotNull((Object)request, (String)"HttpServletRequest was null");
    }

    @Override
    @Nullable
    public X509Certificate getAttesterCertificate() {
        try {
            ServletRequestX509CredentialAdapter credential = new ServletRequestX509CredentialAdapter((ServletRequest)this.servletRequest);
            return credential.getEntityCertificate();
        }
        catch (SecurityException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public String getAttesterIPAddress() {
        return HttpServletSupport.getRemoteAddr((ServletRequest)this.servletRequest);
    }

    @Override
    @Nullable
    public String getReceiverEndpointURI() {
        return this.servletRequest.getRequestURL().toString();
    }
}

