/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class DecodeMessage
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DecodeMessage.class);
    @Nonnull
    private final MessageDecoder decoder;

    public DecodeMessage(@Nonnull MessageDecoder messageDecoder) {
        this.decoder = (MessageDecoder)Constraint.isNotNull((Object)messageDecoder, (String)"MessageDecoder cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            Object msg;
            this.log.debug("{} Decoding message using message decoder of type {} for this request", (Object)this.getLogPrefix(), (Object)this.decoder.getClass().getName());
            this.decoder.decode();
            MessageContext msgContext = this.decoder.getMessageContext();
            Object object = msg = msgContext != null ? msgContext.getMessage() : null;
            if (msg != null) {
                this.log.debug("{} Incoming request decoded into a message of type {}", (Object)this.getLogPrefix(), (Object)msg.getClass().getName());
            } else {
                this.log.warn("{} Decoder did not produce an incoming message?", (Object)this.getLogPrefix());
            }
            profileRequestContext.setInboundMessageContext(msgContext);
        }
        catch (MessageDecodingException e) {
            this.log.error("{} Unable to decode incoming request", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToDecode");
        }
        finally {
            this.decoder.destroy();
        }
    }
}

