/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.util;

import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObjectBuilder;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IndexedXMLObjectChildrenListTest {
    private QName type1 = new QName("example.org/ns/type1", "Type1");
    private QName type2 = new QName("example.org/ns/type2", "Type2");
    private SimpleXMLObjectBuilder sxoBuilder = new SimpleXMLObjectBuilder();

    @Test
    public void testAdd() {
        SimpleXMLObject parentObject = this.sxoBuilder.buildObject();
        IndexedXMLObjectChildrenList indexedList = new IndexedXMLObjectChildrenList((XMLObject)parentObject);
        SimpleXMLObject child1 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type1);
        indexedList.add((Object)child1);
        Assert.assertEquals((int)indexedList.get(child1.getElementQName()).size(), (int)1, (String)"List gotten by element QName index should have had 1 element");
        Assert.assertEquals((int)indexedList.get(child1.getSchemaType()).size(), (int)1, (String)"List gotten by type QName index should have had 1 element");
        SimpleXMLObject child2 = this.sxoBuilder.buildObject();
        indexedList.add((Object)child2);
        Assert.assertEquals((int)indexedList.get(child1.getElementQName()).size(), (int)2, (String)"List gotten by element QName index should have had 1 element");
        Assert.assertEquals((int)indexedList.get(child1.getSchemaType()).size(), (int)1, (String)"List gotten by type QName index should have had 1 element");
    }

    @Test
    public void testSet() {
        SimpleXMLObject parentObject = this.sxoBuilder.buildObject();
        IndexedXMLObjectChildrenList indexedList = new IndexedXMLObjectChildrenList((XMLObject)parentObject);
        SimpleXMLObject child1 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type1);
        indexedList.add((Object)child1);
        SimpleXMLObject child2 = this.sxoBuilder.buildObject();
        indexedList.set(0, (XMLObject)child2);
        Assert.assertEquals((int)indexedList.get(child1.getElementQName()).size(), (int)1, (String)"List gotten by element QName index should have had 1 element");
        Assert.assertTrue((boolean)indexedList.get(child1.getSchemaType()).isEmpty(), (String)"List gotten by type QName index should have been empty");
    }

    @Test
    public void testRemove() {
        SimpleXMLObject parentObject = this.sxoBuilder.buildObject();
        IndexedXMLObjectChildrenList indexedList = new IndexedXMLObjectChildrenList((XMLObject)parentObject);
        SimpleXMLObject child1 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type1);
        indexedList.add((Object)child1);
        SimpleXMLObject child2 = this.sxoBuilder.buildObject();
        indexedList.add((Object)child2);
        indexedList.remove((XMLObject)child1);
        Assert.assertEquals((int)indexedList.get(child1.getElementQName()).size(), (int)1, (String)"List gotten by element QName index should have had 1 element");
        Assert.assertTrue((boolean)indexedList.get(child1.getSchemaType()).isEmpty(), (String)"List gotten by type QName index should have been empty");
    }

    @Test
    public void testSublist() {
        SimpleXMLObject parentObject = this.sxoBuilder.buildObject();
        IndexedXMLObjectChildrenList indexedList = new IndexedXMLObjectChildrenList((XMLObject)parentObject);
        SimpleXMLObject child1 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type1);
        indexedList.add((Object)child1);
        SimpleXMLObject child2 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type2);
        indexedList.add((Object)child2);
        SimpleXMLObject child3 = this.sxoBuilder.buildObject();
        indexedList.add((Object)child3);
        SimpleXMLObject child4 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type2);
        indexedList.add((Object)child4);
        SimpleXMLObject child5 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type1);
        indexedList.add((Object)child5);
        SimpleXMLObject child6 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type1);
        indexedList.add((Object)child6);
        List elementNameSublist = indexedList.subList(child1.getElementQName());
        List type1SchemaSublist = indexedList.subList(this.type1);
        List type2SchemaSublist = indexedList.subList(this.type2);
        Assert.assertEquals((int)elementNameSublist.size(), (int)6, (String)"Element name index sublist did not have expected number of elements");
        Assert.assertEquals((int)type1SchemaSublist.size(), (int)3, (String)"Schema Type1 index sublist did not have expected number of elements");
        Assert.assertEquals((int)type2SchemaSublist.size(), (int)2, (String)"Schema Type2 index sublist did not have expected number of elements");
        elementNameSublist.clear();
        Assert.assertEquals((int)elementNameSublist.size(), (int)0, (String)"Element name index sublist did not have expected number of elements");
        SimpleXMLObject child7 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type1);
        type1SchemaSublist.add(child7);
        Assert.assertTrue((boolean)type1SchemaSublist.contains((Object)child7));
        Assert.assertTrue((boolean)indexedList.contains((XMLObject)child7));
        type1SchemaSublist.remove((Object)child7);
        Assert.assertFalse((boolean)type1SchemaSublist.contains((Object)child7));
        Assert.assertFalse((boolean)indexedList.contains((XMLObject)child7));
        try {
            type1SchemaSublist.set(0, child7);
            Assert.fail((String)"Unsupported set operation did not throw proper exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            type1SchemaSublist.remove(0);
            Assert.fail((String)"Unsupported remove operation did not throw proper exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testSublistIndexOf() {
        SimpleXMLObject parentObject = this.sxoBuilder.buildObject();
        IndexedXMLObjectChildrenList indexedList = new IndexedXMLObjectChildrenList((XMLObject)parentObject);
        SimpleXMLObject child1 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type1);
        indexedList.add((Object)child1);
        SimpleXMLObject child2 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type2);
        indexedList.add((Object)child2);
        List sublist = indexedList.subList(this.type2);
        Assert.assertTrue((child2 == sublist.get(sublist.indexOf((Object)child2)) ? 1 : 0) != 0);
    }

    public void testSublistLastIndexOf() {
        SimpleXMLObject parentObject = this.sxoBuilder.buildObject();
        IndexedXMLObjectChildrenList indexedList = new IndexedXMLObjectChildrenList((XMLObject)parentObject);
        SimpleXMLObject child1 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type1);
        indexedList.add((Object)child1);
        SimpleXMLObject child2 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type2);
        indexedList.add((Object)child2);
        SimpleXMLObject child3 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type1);
        indexedList.add((Object)child3);
        List sublist = indexedList.subList(this.type1);
        Assert.assertTrue((child3 == sublist.get(sublist.lastIndexOf((Object)child3)) ? 1 : 0) != 0);
    }

    public void testSublistClear() {
        SimpleXMLObject parentObject = this.sxoBuilder.buildObject();
        IndexedXMLObjectChildrenList indexedList = new IndexedXMLObjectChildrenList((XMLObject)parentObject);
        SimpleXMLObject child1 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type1);
        indexedList.add((Object)child1);
        SimpleXMLObject child2 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type2);
        indexedList.add((Object)child2);
        SimpleXMLObject child3 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type1);
        indexedList.add((Object)child3);
        SimpleXMLObject child4 = (SimpleXMLObject)this.sxoBuilder.buildObject(SimpleXMLObject.ELEMENT_NAME, this.type1);
        indexedList.add((Object)child4);
        Assert.assertEquals((int)4, (int)indexedList.size());
        List sublist = indexedList.subList(this.type1);
        Assert.assertEquals((int)3, (int)sublist.size());
        sublist.clear();
        Assert.assertEquals((int)0, (int)sublist.size());
        Assert.assertEquals((int)1, (int)indexedList.size());
        Assert.assertTrue((boolean)indexedList.contains((XMLObject)child2));
    }
}

