/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.util;

import java.util.Objects;
import java.util.Set;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.Namespace;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.util.AttributeMap;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeMapTest
extends XMLObjectBaseTestCase {
    private AttributeExtensibleXMLObject owner;
    private AttributeMap attributeMap;
    private static String ns1 = "urn:test:ns1";
    private static String ns1Prefix = "testNS1";
    private static String ns2 = "urn:test:ns2";
    private static String ns2Prefix = "testNS2";
    private static String ns3 = "urn:test:ns3";
    private static String ns3Prefix = "testNS3";
    private static QName elementName = new QName(ns1, "TestElementName", ns1Prefix);
    private XMLObjectBuilder<XSAny> xsAnyBuilder;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.xsAnyBuilder = builderFactory.getBuilderOrThrow(XSAny.TYPE_NAME);
        this.owner = (AttributeExtensibleXMLObject)this.xsAnyBuilder.buildObject(elementName);
        this.attributeMap = this.owner.getUnknownAttributes();
    }

    @Test
    public void testClear() {
        QName attrName1 = new QName(ns1, "Attr1", ns1Prefix);
        QName attrName2 = new QName(ns2, "Attr2", ns2Prefix);
        QName attrName3 = new QName(ns3, "Attr3", ns3Prefix);
        this.attributeMap.put(attrName1, "foo");
        this.attributeMap.put(attrName2, "foo");
        this.attributeMap.put(attrName3, "foo");
        Assert.assertEquals((int)this.attributeMap.size(), (int)3, (String)"Wrong map size");
        this.owner.getUnknownAttributes().clear();
        Assert.assertEquals((int)this.attributeMap.size(), (int)0, (String)"Wrong map size");
    }

    @Test
    public void testAttributeMapQualifiedAttributes() {
        QName attrName1 = new QName(ns1, "Attr1", ns1Prefix);
        QName attrName2 = new QName(ns2, "Attr2", ns2Prefix);
        QName attrName3 = new QName(ns3, "Attr3", ns3Prefix);
        this.attributeMap.put(attrName1, "foo");
        this.checkNamespaces((XMLObject)this.owner, 1, elementName, attrName1);
        this.attributeMap.remove((Object)attrName1);
        this.checkNamespaces((XMLObject)this.owner, 1, elementName);
        this.attributeMap.put(attrName2, "foo");
        this.checkNamespaces((XMLObject)this.owner, 2, elementName, attrName2);
        this.attributeMap.remove((Object)attrName2);
        this.checkNamespaces((XMLObject)this.owner, 1, elementName);
        this.attributeMap.put(attrName2, "foo");
        this.attributeMap.put(attrName3, "foo");
        this.checkNamespaces((XMLObject)this.owner, 3, elementName, attrName2, attrName3);
        this.attributeMap.clear();
        this.checkNamespaces((XMLObject)this.owner, 1, elementName);
    }

    @Test
    public void testQNameAttributeValueAsString() {
        QName attrName = new QName(ns2, "Attr2", ns2Prefix);
        QName attrValue = new QName(ns3, "foo", ns3Prefix);
        String attrValueString = attrValue.getPrefix() + ":" + attrValue.getLocalPart();
        this.owner.getNamespaceManager().registerNamespaceDeclaration(this.buildNamespace(attrValue));
        this.owner.getUnknownAttributes().put(attrName, attrValueString);
        this.checkNamespaces((XMLObject)this.owner, 3, elementName, attrName, attrValue);
    }

    @Test
    public void testQNameAttributeValueAsQName() {
        QName attrName = new QName(ns2, "Attr2", ns2Prefix);
        QName attrValue = new QName(ns3, "foo", ns3Prefix);
        this.owner.getUnknownAttributes().put(attrName, attrValue);
        this.checkNamespaces((XMLObject)this.owner, 3, elementName, attrName, attrValue);
        this.owner.getUnknownAttributes().put(attrName, (QName)null);
        this.checkNamespaces((XMLObject)this.owner, 1, elementName);
    }

    private void checkNamespaces(XMLObject xo, Integer nsSize, QName ... names) {
        Set namespacesPresent = xo.getNamespaces();
        if (nsSize != null) {
            int size = nsSize;
            Assert.assertEquals((int)xo.getNamespaces().size(), (int)size, (String)"Wrong number of unique namespaces");
        }
        block0: for (QName name : names) {
            Namespace nsExpected = this.buildNamespace(name);
            for (Namespace nsPresent : namespacesPresent) {
                if (!this.equals(nsExpected, nsPresent)) continue;
                continue block0;
            }
            Assert.fail((String)("Did not find expected namespace in object from QName: " + name.toString()));
        }
    }

    private Namespace buildNamespace(QName name) {
        String uri = StringSupport.trimOrNull((String)name.getNamespaceURI());
        if (uri == null) {
            throw new IllegalArgumentException("A non-empty namespace URI must be supplied");
        }
        String prefix = StringSupport.trimOrNull((String)name.getPrefix());
        return new Namespace(uri, prefix);
    }

    private boolean equals(Namespace nsa, Namespace nsb) {
        return Objects.equals(nsa.getNamespaceURI(), nsa.getNamespaceURI()) && Objects.equals(nsb.getNamespacePrefix(), nsb.getNamespacePrefix());
    }
}

