/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.schema;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSQName;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class XSQNameTest
extends XMLObjectBaseTestCase {
    private String testDocumentLocation;
    private QName expectedXMLObjectQName;
    private QName expectedValue;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.testDocumentLocation = "/org/opensaml/core/xml/schema/xsQName.xml";
        this.expectedXMLObjectQName = new QName("urn:example.org:foo", "bar", "foo");
        this.expectedValue = new QName("urn:example.org:baz", "SomeValue", "baz");
    }

    @Test
    public void testMarshall() throws MarshallingException, XMLParserException {
        XMLObjectBuilder xsQNameBuilder = builderFactory.getBuilderOrThrow(XSQName.TYPE_NAME);
        XSQName xsQName = (XSQName)xsQNameBuilder.buildObject(this.expectedXMLObjectQName, XSQName.TYPE_NAME);
        xsQName.setValue(this.expectedValue);
        Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)xsQName);
        marshaller.marshall((XMLObject)xsQName);
        Document document = parserPool.parse(XSQNameTest.class.getResourceAsStream(this.testDocumentLocation));
        this.assertXMLEquals("Marshalled XSQName does not match example document", document, (XMLObject)xsQName);
    }

    @Test
    public void testUnmarshall() throws XMLParserException, UnmarshallingException {
        Document document = parserPool.parse(XSQNameTest.class.getResourceAsStream(this.testDocumentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        XSQName xsQName = (XSQName)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertEquals((Object)xsQName.getElementQName(), (Object)this.expectedXMLObjectQName, (String)"Unexpected XSQName QName");
        Assert.assertEquals((Object)xsQName.getSchemaType(), (Object)XSQName.TYPE_NAME, (String)"Unexpected XSQName schema type");
        Assert.assertEquals((Object)xsQName.getValue(), (Object)this.expectedValue, (String)"Unexpected value of XSQName");
    }
}

