/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObjectBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class XMLObjectXSIAttribsTest
extends XMLObjectBaseTestCase {
    private QName simpleXMLObjectQName = new QName("http://www.example.org/testObjects", "SimpleElement");

    @Test
    public void testUnmarshallNoNil() throws XMLParserException, UnmarshallingException {
        String documentLocation = "/org/opensaml/core/xml/SimpleXMLObjectWithAttribute.xml";
        Document document = parserPool.parse(XMLObjectXSIAttribsTest.class.getResourceAsStream(documentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        SimpleXMLObject sxObject = (SimpleXMLObject)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertNull((Object)sxObject.isNilXSBoolean());
        Assert.assertFalse((boolean)sxObject.isNil(), (String)"Expected isNil() false");
    }

    @Test
    public void testUnmarshallNil() throws XMLParserException, UnmarshallingException {
        String documentLocation = "/org/opensaml/core/xml/SimpleXMLObjectNil.xml";
        Document document = parserPool.parse(XMLObjectXSIAttribsTest.class.getResourceAsStream(documentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        SimpleXMLObject sxObject = (SimpleXMLObject)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertNotNull((Object)sxObject.isNilXSBoolean());
        Assert.assertTrue((boolean)sxObject.isNil(), (String)"Expected isNil() true");
    }

    @Test
    public void testMarshallNil() throws XMLParserException {
        String expectedDocumentLocation = "/org/opensaml/core/xml/SimpleXMLObjectNil.xml";
        Document expectedDocument = parserPool.parse(XMLObjectXSIAttribsTest.class.getResourceAsStream(expectedDocumentLocation));
        SimpleXMLObjectBuilder sxoBuilder = (SimpleXMLObjectBuilder)builderFactory.getBuilder(this.simpleXMLObjectQName);
        SimpleXMLObject sxObject = sxoBuilder.buildObject();
        sxObject.setNil(true);
        this.assertXMLEquals(expectedDocument, (XMLObject)sxObject);
    }

    @Test
    public void testUnmarshallSchemaLocation() throws XMLParserException, UnmarshallingException {
        String expectedValue = "http://www.example.com/Test http://www.example.com/Test.xsd";
        String documentLocation = "/org/opensaml/core/xml/SimpleXMLObjectSchemaLocation.xml";
        Document document = parserPool.parse(XMLObjectXSIAttribsTest.class.getResourceAsStream(documentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        SimpleXMLObject sxObject = (SimpleXMLObject)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertEquals((String)sxObject.getSchemaLocation(), (String)expectedValue, (String)"Incorrect xsi:schemaLocation value");
    }

    @Test
    public void testMarshallSchemaLocation() throws XMLParserException {
        String expectedValue = "http://www.example.com/Test http://www.example.com/Test.xsd";
        String expectedDocumentLocation = "/org/opensaml/core/xml/SimpleXMLObjectSchemaLocation.xml";
        Document expectedDocument = parserPool.parse(XMLObjectXSIAttribsTest.class.getResourceAsStream(expectedDocumentLocation));
        SimpleXMLObjectBuilder sxoBuilder = (SimpleXMLObjectBuilder)builderFactory.getBuilder(this.simpleXMLObjectQName);
        SimpleXMLObject sxObject = sxoBuilder.buildObject();
        sxObject.setSchemaLocation(expectedValue);
        this.assertXMLEquals(expectedDocument, (XMLObject)sxObject);
    }

    @Test
    public void testUnmarshallNoNamespaceSchemaLocation() throws XMLParserException, UnmarshallingException {
        String expectedValue = "http://www.example.com/Test.xsd";
        String documentLocation = "/org/opensaml/core/xml/SimpleXMLObjectNoNamespaceSchemaLocation.xml";
        Document document = parserPool.parse(XMLObjectXSIAttribsTest.class.getResourceAsStream(documentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        SimpleXMLObject sxObject = (SimpleXMLObject)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertEquals((String)sxObject.getNoNamespaceSchemaLocation(), (String)expectedValue, (String)"Incorrect xsi:noNamespaceSchemaLocation value");
    }

    @Test
    public void testMarshallNoNamespaceSchemaLocation() throws XMLParserException {
        String expectedValue = "http://www.example.com/Test.xsd";
        String expectedDocumentLocation = "/org/opensaml/core/xml/SimpleXMLObjectNoNamespaceSchemaLocation.xml";
        Document expectedDocument = parserPool.parse(XMLObjectXSIAttribsTest.class.getResourceAsStream(expectedDocumentLocation));
        SimpleXMLObjectBuilder sxoBuilder = (SimpleXMLObjectBuilder)builderFactory.getBuilder(this.simpleXMLObjectQName);
        SimpleXMLObject sxObject = sxoBuilder.buildObject();
        sxObject.setNoNamespaceSchemaLocation(expectedValue);
        this.assertXMLEquals(expectedDocument, (XMLObject)sxObject);
    }
}

