/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.testing;

import net.shibboleth.utilities.java.support.xml.ElementSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class XMLObjectProviderBaseTestCase
extends XMLObjectBaseTestCase {
    protected String singleElementFile;
    protected String singleElementOptionalAttributesFile;
    protected String singleElementUnknownAttributesFile;
    protected String childElementsFile;
    protected String invalidFile;
    protected Document expectedDOM;
    protected Document expectedOptionalAttributesDOM;
    protected Document expectedUnknownAttributesDOM;
    protected Document expectedChildElementsDOM;
    protected Document invalidDOM;

    @BeforeClass
    protected void initXMLObjectProviderTestingSupprt() throws Exception {
        if (this.singleElementFile != null) {
            this.expectedDOM = parserPool.parse(XMLObjectProviderBaseTestCase.class.getResourceAsStream(this.singleElementFile));
        }
        if (this.singleElementOptionalAttributesFile != null) {
            this.expectedOptionalAttributesDOM = parserPool.parse(XMLObjectProviderBaseTestCase.class.getResourceAsStream(this.singleElementOptionalAttributesFile));
        }
        if (this.childElementsFile != null) {
            this.expectedChildElementsDOM = parserPool.parse(XMLObjectProviderBaseTestCase.class.getResourceAsStream(this.childElementsFile));
        }
        if (this.singleElementUnknownAttributesFile != null) {
            this.expectedUnknownAttributesDOM = parserPool.parse(XMLObjectProviderBaseTestCase.class.getResourceAsStream(this.singleElementUnknownAttributesFile));
        }
        if (this.invalidFile != null) {
            this.invalidDOM = parserPool.parse(XMLObjectProviderBaseTestCase.class.getResourceAsStream(this.invalidFile));
        }
    }

    public abstract void testSingleElementUnmarshall();

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Assert.assertNull((Object)this.singleElementOptionalAttributesFile, (String)"No testSingleElementOptionalAttributesUnmarshall present");
    }

    @Test
    public void testSingleElementUnknownAttributesUnmarshall() {
        Assert.assertNull((Object)this.singleElementUnknownAttributesFile, (String)"No testSingleElementUnknownAttributesUnmarshall present");
    }

    @Test
    public void testChildElementsUnmarshall() {
        Assert.assertNull((Object)this.childElementsFile, (String)"No testSingleElementChildElementsUnmarshall present");
    }

    public abstract void testSingleElementMarshall();

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        Assert.assertNull((Object)this.expectedOptionalAttributesDOM, (String)"No testSingleElementOptionalAttributesMarshall");
    }

    @Test
    public void testSingleElementUnknownAttributesMarshall() {
        Assert.assertNull((Object)this.expectedUnknownAttributesDOM, (String)"No testSingleUnknownAttributesMarshall");
    }

    @Test
    public void testChildElementsMarshall() {
        Assert.assertNull((Object)this.expectedChildElementsDOM, (String)"No testSingleElementChildElementsMarshall");
    }

    public void testAttributeIDnessMarshall(XMLObject target, String idValue) throws MarshallingException, XMLParserException {
        Element origDOM = XMLObjectSupport.getMarshaller((XMLObject)target).marshall(target);
        Element resolvedDOM = origDOM.getOwnerDocument().getElementById(idValue);
        Assert.assertNotNull((Object)resolvedDOM);
        Assert.assertTrue((boolean)origDOM.isSameNode(resolvedDOM));
        Document newDocument = XMLObjectProviderRegistrySupport.getParserPool().newDocument();
        origDOM = XMLObjectSupport.getMarshaller((XMLObject)target).marshall(target, newDocument);
        resolvedDOM = newDocument.getElementById(idValue);
        Assert.assertNotNull((Object)resolvedDOM);
        Assert.assertTrue((boolean)origDOM.isSameNode(resolvedDOM));
        newDocument = XMLObjectProviderRegistrySupport.getParserPool().newDocument();
        Element parent = ElementSupport.constructElement((Document)newDocument, (String)"urn:test:foo", (String)"Foo", (String)"foo");
        ElementSupport.setDocumentElement((Document)newDocument, (Element)parent);
        origDOM = XMLObjectSupport.getMarshaller((XMLObject)target).marshall(target, parent);
        resolvedDOM = newDocument.getElementById(idValue);
        Assert.assertNotNull((Object)resolvedDOM);
        Assert.assertTrue((boolean)origDOM.isSameNode(resolvedDOM));
    }
}

