/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.testing;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Diff;

public abstract class XMLObjectBaseTestCase
extends OpenSAMLInitBaseTestCase {
    private final Logger log = LoggerFactory.getLogger(XMLObjectBaseTestCase.class);
    protected static ParserPool parserPool;
    protected static XMLObjectBuilderFactory builderFactory;
    protected static MarshallerFactory marshallerFactory;
    protected static UnmarshallerFactory unmarshallerFactory;
    protected static QName simpleXMLObjectQName;

    @BeforeClass
    protected void initXMLObjectSupport() throws Exception {
        try {
            parserPool = XMLObjectProviderRegistrySupport.getParserPool();
            builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
            marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
        }
        catch (Exception e) {
            this.log.error("Can not initialize XMLObjectBaseTestCase: {}", (Object)e.getMessage());
            throw e;
        }
    }

    protected void assertXMLEquals(Document expectedDOM, XMLObject xmlObject) {
        this.assertXMLEquals("Marshalled DOM was not the same as the expected DOM", expectedDOM, xmlObject);
    }

    protected void assertXMLEquals(String failMessage, Document expectedDOM, XMLObject xmlObject) {
        Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
        if (marshaller == null) {
            Assert.fail((String)("Unable to locate marshaller for " + xmlObject.getElementQName() + " can not perform equality check assertion"));
        }
        try {
            Element generatedDOM = marshaller.marshall(xmlObject, parserPool.newDocument());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Marshalled DOM was " + SerializeSupport.nodeToString((Node)generatedDOM));
            }
            Diff diff = DiffBuilder.compare((Object)expectedDOM).withTest((Object)generatedDOM.getOwnerDocument()).ignoreWhitespace().checkForIdentical().build();
            Assert.assertFalse((boolean)diff.hasDifferences(), (String)failMessage);
        }
        catch (Exception e) {
            Assert.fail((String)("Marshalling failed with the following error: " + e));
        }
    }

    protected <T extends XMLObject> T buildXMLObject(QName name) {
        XMLObjectBuilder<T> builder = this.getBuilder(name);
        if (builder == null) {
            Assert.fail((String)("no builder registered for: " + name));
        }
        XMLObject wsObj = builder.buildObject(name);
        Assert.assertNotNull((Object)wsObj);
        return (T)wsObj;
    }

    protected <T extends XMLObject> T unmarshallElement(String elementFile) {
        try {
            return this.unmarshallElement(elementFile, false);
        }
        catch (XMLParserException | UnmarshallingException e) {
            Assert.fail((String)("Unable to parse or unmarshall element file " + elementFile + ": " + (Exception)e));
            return null;
        }
    }

    protected <T extends XMLObject> T unmarshallElement(String elementFile, boolean propagateErrors) throws XMLParserException, UnmarshallingException {
        try {
            Document doc = this.parseXMLDocument(elementFile);
            Element element = doc.getDocumentElement();
            Unmarshaller unmarshaller = this.getUnmarshaller(element);
            XMLObject object = unmarshaller.unmarshall(element);
            Assert.assertNotNull((Object)object);
            return (T)object;
        }
        catch (XMLParserException e) {
            if (propagateErrors) {
                throw e;
            }
            Assert.fail((String)("Unable to parse element file " + elementFile));
        }
        catch (UnmarshallingException e) {
            if (propagateErrors) {
                throw e;
            }
            Assert.fail((String)("Unmarshalling failed when parsing element file " + elementFile + ": " + e));
        }
        return null;
    }

    protected void printXML(Node node, String filename) {
        try {
            SerializeSupport.writeNode((Node)node, (OutputStream)new FileOutputStream(new File(filename)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void printXML(XMLObject xmlObject, String filename) {
        Element elem = null;
        try {
            elem = marshallerFactory.getMarshaller(xmlObject).marshall(xmlObject);
        }
        catch (MarshallingException e) {
            e.printStackTrace();
        }
        this.printXML(elem, filename);
    }

    protected <T extends XMLObject> XMLObjectBuilder<T> getBuilder(QName qname) {
        return builderFactory.getBuilderOrThrow(qname);
    }

    protected Marshaller getMarshaller(QName qname) {
        Marshaller marshaller = marshallerFactory.getMarshaller(qname);
        if (marshaller == null) {
            Assert.fail((String)("no marshaller registered for " + qname));
        }
        return marshaller;
    }

    protected Marshaller getMarshaller(XMLObject xmlObject) {
        Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
        if (marshaller == null) {
            Assert.fail((String)("no marshaller registered for " + xmlObject.getClass().getName()));
        }
        return marshaller;
    }

    protected Unmarshaller getUnmarshaller(QName qname) {
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(qname);
        if (unmarshaller == null) {
            Assert.fail((String)("no unmarshaller registered for " + qname));
        }
        return unmarshaller;
    }

    protected Unmarshaller getUnmarshaller(XMLObject xmlObject) {
        return this.getUnmarshaller(xmlObject.getElementQName());
    }

    protected Unmarshaller getUnmarshaller(Element element) {
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
        if (unmarshaller == null) {
            Assert.fail((String)("no unmarshaller registered for " + QNameSupport.getNodeQName((Node)element)));
        }
        return unmarshaller;
    }

    protected Document parseXMLDocument(String xmlFilename) throws XMLParserException {
        InputStream is = this.getClass().getResourceAsStream(xmlFilename);
        Document doc = parserPool.parse(is);
        return doc;
    }

    static {
        simpleXMLObjectQName = new QName("http://www.example.org/testObjects", "SimpleElement");
    }
}

