/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import org.opensaml.core.metrics.MetricsSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MetricsSupportTest {
    private MetricRegistry registry;
    private Gauge<Integer> gauge1;
    private Gauge<Integer> gauge2;

    @BeforeClass
    public void setUpGauges() {
        this.gauge1 = new Gauge<Integer>(){

            public Integer getValue() {
                return 42;
            }
        };
        this.gauge2 = new Gauge<Integer>(){

            public Integer getValue() {
                return 100;
            }
        };
    }

    @BeforeMethod
    public void setUp() {
        this.registry = new MetricRegistry();
    }

    @Test
    public void testRegister() {
        String name = "test1";
        Assert.assertNull(this.registry.getMetrics().get(name));
        MetricsSupport.register((String)name, this.gauge1, (boolean)false, (MetricRegistry)this.registry);
        Assert.assertNotNull(this.registry.getMetrics().get(name));
        Assert.assertSame(this.registry.getMetrics().get(name), this.gauge1);
        try {
            MetricsSupport.register((String)name, this.gauge2, (boolean)false, (MetricRegistry)this.registry);
            Assert.fail((String)"Should have failed due to duplicate registration under existing name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertSame(this.registry.getMetrics().get(name), this.gauge1);
        MetricsSupport.register((String)name, this.gauge2, (boolean)true, (MetricRegistry)this.registry);
        Assert.assertNotNull(this.registry.getMetrics().get(name));
        Assert.assertSame(this.registry.getMetrics().get(name), this.gauge2);
    }

    @Test
    public void testRemoveSameInstance() {
        String name = "test1";
        Assert.assertNull(this.registry.getMetrics().get(name));
        this.registry.register(name, this.gauge1);
        Assert.assertNotNull(this.registry.getMetrics().get(name));
        Assert.assertTrue((boolean)MetricsSupport.remove((String)name, this.gauge1, (MetricRegistry)this.registry));
        Assert.assertNull(this.registry.getMetrics().get(name));
    }

    @Test
    public void testRemoveDifferingInstance() {
        String name = "test1";
        Assert.assertNull(this.registry.getMetrics().get(name));
        this.registry.register(name, this.gauge1);
        Assert.assertNotNull(this.registry.getMetrics().get(name));
        Assert.assertFalse((boolean)MetricsSupport.remove((String)name, this.gauge2, (MetricRegistry)this.registry));
        Assert.assertNotNull(this.registry.getMetrics().get(name));
        Assert.assertSame(this.registry.getMetrics().get(name), this.gauge1);
    }

    @Test
    public void testIsInstanceRegisteredUnderName() {
        String name = "test1";
        Assert.assertNull(this.registry.getMetrics().get(name));
        this.registry.register(name, this.gauge1);
        Assert.assertNotNull(this.registry.getMetrics().get(name));
        Assert.assertTrue((boolean)MetricsSupport.isMetricInstanceRegisteredUnderName((String)name, this.gauge1, (MetricRegistry)this.registry));
        Assert.assertFalse((boolean)MetricsSupport.isMetricInstanceRegisteredUnderName((String)"testXXX", this.gauge1, (MetricRegistry)this.registry));
        Assert.assertFalse((boolean)MetricsSupport.isMetricInstanceRegisteredUnderName((String)name, this.gauge2, (MetricRegistry)this.registry));
    }
}

