/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.config;

import org.opensaml.core.config.ConfigurationService;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConfigurationServiceTest {
    @Test
    public void testBasicRegistrationAndRetrievalAsClass() {
        Assert.assertNull((Object)ConfigurationService.get(BasicTestConfig.class));
        BasicTestConfig config = new BasicTestConfig();
        config.setValue("test-value");
        ConfigurationService.register(BasicTestConfig.class, (Object)config);
        Assert.assertNotNull((Object)ConfigurationService.get(BasicTestConfig.class));
        BasicTestConfig retrievedConfig = (BasicTestConfig)ConfigurationService.get(BasicTestConfig.class);
        Assert.assertEquals((String)retrievedConfig.getValue(), (String)"test-value");
        ConfigurationService.deregister(BasicTestConfig.class);
        Assert.assertNull((Object)ConfigurationService.get(BasicTestConfig.class));
    }

    @Test
    public void testBasicRegistrationAndRetrievalAsInterface() {
        Assert.assertNull((Object)ConfigurationService.get(TestConfig.class));
        BasicTestConfig config = new BasicTestConfig();
        config.setValue("test-value");
        ConfigurationService.register(TestConfig.class, (Object)config);
        Assert.assertNotNull((Object)ConfigurationService.get(TestConfig.class));
        TestConfig retrievedConfig = (TestConfig)ConfigurationService.get(TestConfig.class);
        Assert.assertEquals((String)retrievedConfig.getValue(), (String)"test-value");
        ConfigurationService.deregister(TestConfig.class);
        Assert.assertNull((Object)ConfigurationService.get(TestConfig.class));
    }

    public class BasicTestConfig
    implements TestConfig {
        private String value;

        @Override
        public String getValue() {
            return this.value;
        }

        public void setValue(String newValue) {
            this.value = newValue;
        }
    }

    public static interface TestConfig {
        public String getValue();
    }
}

