/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.persist;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.time.Instant;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.shibboleth.utilities.java.support.collection.Pair;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.core.xml.persist.MapLoadSaveManager;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MapLoadSaveManagerTest
extends XMLObjectBaseTestCase {
    private MapLoadSaveManager<SimpleXMLObject> manager;

    @BeforeMethod
    public void setup() {
        this.manager = new MapLoadSaveManager();
    }

    @Test
    public void emptyMap() throws IOException {
        this.testState(Sets.newHashSet());
    }

    @Test
    public void saveLoadUpdateRemove() throws IOException {
        this.testState(Sets.newHashSet());
        Assert.assertNull((Object)this.manager.load("bogus"));
        this.manager.save("foo", (XMLObject)((SimpleXMLObject)((Object)this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME))));
        this.testState(Sets.newHashSet((Object[])new String[]{"foo"}));
        this.manager.save("bar", (XMLObject)((SimpleXMLObject)((Object)this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME))));
        this.manager.save("baz", (XMLObject)((SimpleXMLObject)((Object)this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME))));
        this.testState(Sets.newHashSet((Object[])new String[]{"foo", "bar", "baz"}));
        this.manager.save("bar", (XMLObject)((SimpleXMLObject)((Object)this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME))), true);
        this.testState(Sets.newHashSet((Object[])new String[]{"foo", "bar", "baz"}));
        try {
            this.manager.save("bar", (XMLObject)((SimpleXMLObject)((Object)this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME))), false);
            Assert.fail((String)"Should have failed on duplicate save without overwrite");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.testState(Sets.newHashSet((Object[])new String[]{"foo", "bar", "baz"}));
        this.testState(Sets.newHashSet((Object[])new String[]{"foo", "bar", "baz"}));
        Assert.assertTrue((boolean)this.manager.updateKey("foo", "foo2"));
        this.testState(Sets.newHashSet((Object[])new String[]{"foo2", "bar", "baz"}));
        Assert.assertFalse((boolean)this.manager.updateKey("foo", "foo2"));
        this.testState(Sets.newHashSet((Object[])new String[]{"foo2", "bar", "baz"}));
        try {
            this.manager.updateKey("bar", "baz");
            Assert.fail((String)"updateKey should have failed to due existing new key name");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.testState(Sets.newHashSet((Object[])new String[]{"foo2", "bar", "baz"}));
        Assert.assertFalse((boolean)this.manager.remove("foo"));
        this.testState(Sets.newHashSet((Object[])new String[]{"foo2", "bar", "baz"}));
        Assert.assertTrue((boolean)this.manager.remove("foo2"));
        this.testState(Sets.newHashSet((Object[])new String[]{"bar", "baz"}));
        Assert.assertTrue((boolean)this.manager.remove("bar"));
        Assert.assertTrue((boolean)this.manager.remove("baz"));
        this.testState(Sets.newHashSet());
    }

    @Test
    public void checkCheckModifyTimeTracking() throws IOException {
        this.manager = new MapLoadSaveManager(true);
        Assert.assertNull((Object)this.manager.load("foo"));
        Assert.assertNull((Object)this.manager.getLoadLastModified("foo"));
        this.manager.save("foo", (XMLObject)((SimpleXMLObject)((Object)this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME))));
        Assert.assertNotNull((Object)this.manager.load("foo"));
        Instant initialCachedModified = this.manager.getLoadLastModified("foo");
        Assert.assertNotNull((Object)initialCachedModified);
        Assert.assertNull((Object)this.manager.load("foo"));
        Assert.assertEquals((Object)this.manager.getLoadLastModified("foo"), (Object)initialCachedModified);
        Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.manager.save("foo", (XMLObject)((SimpleXMLObject)((Object)this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME))), true);
        Assert.assertNotNull((Object)this.manager.load("foo"));
        Instant updatedCachedModified = this.manager.getLoadLastModified("foo");
        Assert.assertNotNull((Object)updatedCachedModified);
        Assert.assertNotEquals((Object)updatedCachedModified, (Object)initialCachedModified);
        Assert.assertNull((Object)this.manager.load("foo"));
        Assert.assertEquals((Object)this.manager.getLoadLastModified("foo"), (Object)updatedCachedModified);
        this.manager.updateKey("foo", "bar");
        Assert.assertNull((Object)this.manager.load("foo"));
        Assert.assertNull((Object)this.manager.load("bar"));
        Assert.assertNull((Object)this.manager.getLoadLastModified("foo"));
        Assert.assertNotNull((Object)this.manager.getLoadLastModified("bar"));
        Assert.assertEquals((Object)this.manager.getLoadLastModified("bar"), (Object)updatedCachedModified);
        this.manager.remove("bar");
        Assert.assertNull((Object)this.manager.getLoadLastModified("bar"));
    }

    @Test
    public void iterator() throws IOException {
        Iterator iterator = null;
        iterator = this.manager.listAll().iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"Should have failed due to no more elements");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.manager.save("foo", (XMLObject)((SimpleXMLObject)((Object)this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME))));
        iterator = this.manager.listAll().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertNotNull(iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"Should have failed due to no more elements");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.manager.save("bar", (XMLObject)((SimpleXMLObject)((Object)this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME))));
        this.manager.save("baz", (XMLObject)((SimpleXMLObject)((Object)this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME))));
        iterator = this.manager.listAll().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertNotNull(iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertNotNull(iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertNotNull(iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"Should have failed due to no more elements");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.manager.remove("foo");
        iterator = this.manager.listAll().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertNotNull(iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertNotNull(iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"Should have failed due to no more elements");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.manager.remove("bar");
        this.manager.remove("baz");
        iterator = this.manager.listAll().iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"Should have failed due to no more elements");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void testState(Set<String> expectedKeys) throws IOException {
        Assert.assertEquals((boolean)this.manager.listKeys().isEmpty(), (expectedKeys.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Set)this.manager.listKeys(), expectedKeys);
        for (String expectedKey : expectedKeys) {
            Assert.assertTrue((boolean)this.manager.exists(expectedKey));
            SimpleXMLObject sxo = (SimpleXMLObject)this.manager.load(expectedKey);
            Assert.assertNotNull((Object)((Object)sxo));
        }
        Assert.assertEquals((boolean)this.manager.listAll().iterator().hasNext(), (!expectedKeys.isEmpty() ? 1 : 0) != 0);
        int sawCount = 0;
        for (Pair entry : this.manager.listAll()) {
            ++sawCount;
            Assert.assertTrue((boolean)expectedKeys.contains(entry.getFirst()));
            Assert.assertNotNull((Object)entry.getSecond());
        }
        Assert.assertEquals((int)sawCount, (int)expectedKeys.size());
    }
}

