/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.util;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObjectBuilder;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.testng.Assert;
import org.testng.annotations.Test;

public class XMLObjectChildrenListTest {
    private SimpleXMLObjectBuilder sxoBuilder = new SimpleXMLObjectBuilder();

    @Test
    public void testAdd() {
        SimpleXMLObject parentObject = this.sxoBuilder.buildObject();
        XMLObjectChildrenList objectList = new XMLObjectChildrenList((XMLObject)parentObject);
        Assert.assertEquals((int)objectList.size(), (int)0, (String)("XMLObject list was supposed to be empty but instead had " + objectList.size() + " elements"));
        objectList.add(null);
        Assert.assertEquals((int)objectList.size(), (int)0, (String)"XMLObject list allowed a null element to be added");
        SimpleXMLObject child1 = this.sxoBuilder.buildObject();
        objectList.add((Object)child1);
        Assert.assertEquals((int)objectList.size(), (int)1, (String)("XMLObject list was supposed to have 1 element but instead had " + objectList.size()));
        Assert.assertEquals((Object)child1.getParent(), (Object)((Object)parentObject), (String)"Child 1 did not have the correct parent object");
        LinkedList<SimpleXMLObject> childList = new LinkedList<SimpleXMLObject>();
        SimpleXMLObject child2 = this.sxoBuilder.buildObject();
        childList.add(child2);
        SimpleXMLObject child3 = this.sxoBuilder.buildObject();
        childList.add(child3);
        objectList.addAll(childList);
        Assert.assertEquals((int)objectList.size(), (int)3, (String)("XMLObject list was supposed to have 3 element but instead had " + objectList.size()));
        Assert.assertEquals((Object)child2.getParent(), (Object)((Object)parentObject), (String)"Child 2 did not have the correct parent object");
        Assert.assertEquals((Object)child3.getParent(), (Object)((Object)parentObject), (String)"Child 3 did not have the correct parent object");
    }

    @Test
    public void testSet() {
        SimpleXMLObject parentObject = this.sxoBuilder.buildObject();
        XMLObjectChildrenList objectList = new XMLObjectChildrenList((XMLObject)parentObject);
        Assert.assertEquals((int)objectList.size(), (int)0, (String)("XMLObject list was supposed to be empty but instead had " + objectList.size() + " elements"));
        SimpleXMLObject child1 = this.sxoBuilder.buildObject();
        objectList.add((Object)child1);
        Assert.assertEquals((int)objectList.size(), (int)1, (String)("XMLObject list was supposed to have 1 element but instead had " + objectList.size()));
        Assert.assertEquals((Object)child1.getParent(), (Object)((Object)parentObject), (String)"Child 1 did not have the correct parent object");
        objectList.set(0, null);
        Assert.assertNotNull((Object)objectList.get(0), (String)"XMLObject list allowed a null element to be set");
        SimpleXMLObject child2 = this.sxoBuilder.buildObject();
        SimpleXMLObject replacedChild = (SimpleXMLObject)objectList.set(0, (XMLObject)child2);
        Assert.assertEquals((int)objectList.size(), (int)1, (String)("XMLObject list was supposed to have 1 element but instead had " + objectList.size()));
        Assert.assertEquals((Object)child2.getParent(), (Object)((Object)parentObject), (String)"Child 2 did not have the correct parent object");
        Assert.assertEquals((Object)objectList.get(0), (Object)((Object)child2), (String)"Child element was not Child 2");
        Assert.assertNull((Object)replacedChild.getParent(), (String)"Replaced child element parent was not null");
        Assert.assertFalse((boolean)objectList.contains((XMLObject)child1), (String)"Child1 still appears in the object list even though it should have been removed");
    }

    @Test
    public void testRemove() {
        SimpleXMLObject parentObject = this.sxoBuilder.buildObject();
        XMLObjectChildrenList objectList = new XMLObjectChildrenList((XMLObject)parentObject);
        SimpleXMLObject child1 = this.sxoBuilder.buildObject();
        objectList.add((Object)child1);
        Assert.assertEquals((int)objectList.size(), (int)1, (String)("XMLObject list was supposed to have 1 element but instead had " + objectList.size()));
        objectList.remove((XMLObject)child1);
        Assert.assertEquals((int)objectList.size(), (int)0, (String)("XMLObject list was supposed to have 0 element but instead had " + objectList.size()));
        Assert.assertNull((Object)child1.getParent(), (String)"Child 1 parent was not null");
        LinkedList<SimpleXMLObject> childList = new LinkedList<SimpleXMLObject>();
        SimpleXMLObject child2 = this.sxoBuilder.buildObject();
        childList.add(child2);
        SimpleXMLObject child3 = this.sxoBuilder.buildObject();
        childList.add(child3);
        objectList.addAll(childList);
        Assert.assertEquals((int)objectList.size(), (int)2, (String)("XMLObject list was supposed to have 2 element but instead had " + objectList.size()));
        objectList.removeAll(childList);
        Assert.assertEquals((int)objectList.size(), (int)0, (String)("XMLObject list was supposed to have 0 element but instead had " + objectList.size()));
        Assert.assertNull((Object)child2.getParent(), (String)"Child 2 parent was not null");
        Assert.assertNull((Object)child3.getParent(), (String)"Child 3 parent was not null");
    }

    @Test
    public void testIterator() {
        SimpleXMLObject parentObject = this.sxoBuilder.buildObject();
        XMLObjectChildrenList objectList = new XMLObjectChildrenList((XMLObject)parentObject);
        SimpleXMLObject child1 = this.sxoBuilder.buildObject();
        objectList.add((Object)child1);
        SimpleXMLObject child2 = this.sxoBuilder.buildObject();
        objectList.add((Object)child2);
        SimpleXMLObject child3 = this.sxoBuilder.buildObject();
        objectList.add((Object)child3);
        Iterator itr = objectList.iterator();
        SimpleXMLObject firstObject = (SimpleXMLObject)((Object)itr.next());
        Assert.assertNotNull((Object)((Object)firstObject), (String)"First iterator was null and should not have been");
        Assert.assertEquals((Object)((Object)firstObject), (Object)((Object)child1), (String)"First iterator object should have been child 1 but was not");
        itr.next();
        itr.remove();
        SimpleXMLObject thirdObject = (SimpleXMLObject)((Object)itr.next());
        Assert.assertEquals((Object)((Object)thirdObject), (Object)((Object)child3), (String)"Third iterator object should have been child 3 but was not");
        Assert.assertNull((Object)child2.getParent(), (String)"Child 2 parent was not null");
        SimpleXMLObject child4 = this.sxoBuilder.buildObject();
        objectList.add((Object)child4);
        try {
            itr.next();
            Assert.fail((String)"Iterator allowed list to change underneath it without failing");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @Test
    public void testClear() {
        SimpleXMLObject parentObject = this.sxoBuilder.buildObject();
        XMLObjectChildrenList objectList = new XMLObjectChildrenList((XMLObject)parentObject);
        LinkedList<SimpleXMLObject> childList = new LinkedList<SimpleXMLObject>();
        SimpleXMLObject child1 = this.sxoBuilder.buildObject();
        childList.add(child1);
        SimpleXMLObject child2 = this.sxoBuilder.buildObject();
        childList.add(child2);
        SimpleXMLObject child3 = this.sxoBuilder.buildObject();
        childList.add(child3);
        objectList.addAll(childList);
        objectList.clear();
        Assert.assertEquals((int)objectList.size(), (int)0, (String)("XMLObject list was supposed to have 0 element buts instead had " + objectList.size()));
        Assert.assertNull((Object)child1.getParent(), (String)"Child 1 parent was not null");
        Assert.assertNull((Object)child2.getParent(), (String)"Child 2 parent was not null");
        Assert.assertNull((Object)child3.getParent(), (String)"Child 2 parent was not null");
    }
}

