/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.schema;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSURI;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class XSURITest
extends XMLObjectBaseTestCase {
    private String testDocumentLocation;
    private QName expectedXMLObjectQName;
    private String expectedValue;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.testDocumentLocation = "/org/opensaml/core/xml/schema/xsURI.xml";
        this.expectedXMLObjectQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AttributeValue", "saml");
        this.expectedValue = "urn:test:foo:bar:baz";
    }

    @Test
    public void testMarshall() throws MarshallingException, XMLParserException {
        XMLObjectBuilder uriBuilder = builderFactory.getBuilderOrThrow(XSURI.TYPE_NAME);
        XSURI xsURI = (XSURI)uriBuilder.buildObject(this.expectedXMLObjectQName, XSURI.TYPE_NAME);
        xsURI.setValue(this.expectedValue);
        Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)xsURI);
        marshaller.marshall((XMLObject)xsURI);
        Document document = parserPool.parse(XSURITest.class.getResourceAsStream(this.testDocumentLocation));
        this.assertXMLEquals("Marshalled XSURI does not match example document", document, (XMLObject)xsURI);
    }

    @Test
    public void testUnmarshall() throws XMLParserException, UnmarshallingException {
        Document document = parserPool.parse(XSURITest.class.getResourceAsStream(this.testDocumentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        XSURI xsURI = (XSURI)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertEquals((Object)xsURI.getElementQName(), (Object)this.expectedXMLObjectQName, (String)"Unexpected XSURI QName");
        Assert.assertEquals((Object)xsURI.getSchemaType(), (Object)XSURI.TYPE_NAME, (String)"Unexpected XSURI schema type");
        Assert.assertEquals((String)this.expectedValue, (String)xsURI.getValue(), (String)"Unexpected value of XSURI");
    }
}

