/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.schema;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSString;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class XSStringTest
extends XMLObjectBaseTestCase {
    private String testDocumentLocation;
    private QName expectedXMLObjectQName;
    private String expectedValue;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.testDocumentLocation = "/org/opensaml/core/xml/schema/xsString.xml";
        this.expectedXMLObjectQName = new QName("urn:example.org:foo", "bar", "foo");
        this.expectedValue = "test";
    }

    @Test
    public void testMarshall() throws MarshallingException, XMLParserException {
        XMLObjectBuilder xssBuilder = builderFactory.getBuilderOrThrow(XSString.TYPE_NAME);
        XSString xsString = (XSString)xssBuilder.buildObject(this.expectedXMLObjectQName, XSString.TYPE_NAME);
        xsString.setValue(this.expectedValue);
        Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)xsString);
        marshaller.marshall((XMLObject)xsString);
        Document document = parserPool.parse(XSStringTest.class.getResourceAsStream(this.testDocumentLocation));
        this.assertXMLEquals("Marshalled XSString does not match example document", document, (XMLObject)xsString);
    }

    @Test
    public void testUnmarshall() throws XMLParserException, UnmarshallingException {
        Document document = parserPool.parse(XSStringTest.class.getResourceAsStream(this.testDocumentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        XSString xsString = (XSString)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertEquals((Object)xsString.getElementQName(), (Object)this.expectedXMLObjectQName, (String)"Unexpected XSString QName");
        Assert.assertEquals((Object)xsString.getSchemaType(), (Object)XSString.TYPE_NAME, (String)"Unexpected XSString schema type");
        Assert.assertEquals((String)this.expectedValue, (String)xsString.getValue(), (String)"Unexpected value of XSString");
    }
}

