/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.schema;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSDateTime;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class XSDateTimeTest
extends XMLObjectBaseTestCase {
    private QName expectedXMLObjectQName;
    private DateTime expectedValue;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedXMLObjectQName = new QName("urn:example.org:foo", "bar", "foo");
        this.expectedValue = new DateTime(2010, 4, 5, 18, 52, 42, 790, (Chronology)ISOChronology.getInstanceUTC());
    }

    @Test
    public void testMarshall() throws MarshallingException, XMLParserException {
        String testDocumentLocation = "/org/opensaml/core/xml/schema/xsDateTime-basic.xml";
        XMLObjectBuilder xsdtBuilder = builderFactory.getBuilderOrThrow(XSDateTime.TYPE_NAME);
        XSDateTime xsDateTime = (XSDateTime)xsdtBuilder.buildObject(this.expectedXMLObjectQName, XSDateTime.TYPE_NAME);
        xsDateTime.setValue(this.expectedValue);
        Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)xsDateTime);
        marshaller.marshall((XMLObject)xsDateTime);
        Document document = parserPool.parse(XSDateTimeTest.class.getResourceAsStream(testDocumentLocation));
        this.assertXMLEquals("Marshalled XSDateTime does not match example document", document, (XMLObject)xsDateTime);
    }

    @Test
    public void testUnmarshall() throws XMLParserException, UnmarshallingException {
        String testDocumentLocation = "/org/opensaml/core/xml/schema/xsDateTime-basic.xml";
        Document document = parserPool.parse(XSDateTimeTest.class.getResourceAsStream(testDocumentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        XSDateTime xsDateTime = (XSDateTime)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertEquals((Object)xsDateTime.getElementQName(), (Object)this.expectedXMLObjectQName, (String)"Unexpected XSDate QName");
        Assert.assertEquals((Object)xsDateTime.getSchemaType(), (Object)XSDateTime.TYPE_NAME, (String)"Unexpected XSDateTime schema type");
        Assert.assertEquals((Object)xsDateTime.getValue().withChronology((Chronology)ISOChronology.getInstanceUTC()), (Object)this.expectedValue, (String)"Unexpected value of XSDateTime");
    }

    @Test
    public void testUnmarshallCanonical() throws XMLParserException, UnmarshallingException {
        String testDocumentLocation = "/org/opensaml/core/xml/schema/xsDateTime-canonical.xml";
        Document document = parserPool.parse(XSDateTimeTest.class.getResourceAsStream(testDocumentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        XSDateTime xsDateTime = (XSDateTime)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertEquals((Object)xsDateTime.getElementQName(), (Object)this.expectedXMLObjectQName, (String)"Unexpected XSDate QName");
        Assert.assertEquals((Object)xsDateTime.getSchemaType(), (Object)XSDateTime.TYPE_NAME, (String)"Unexpected XSDateTime schema type");
        Assert.assertEquals((Object)xsDateTime.getValue().withChronology((Chronology)ISOChronology.getInstanceUTC()), (Object)this.expectedValue, (String)"Unexpected value of XSDateTime");
    }

    @Test
    public void testUnmarshallNoFractional() throws XMLParserException, UnmarshallingException {
        String testDocumentLocation = "/org/opensaml/core/xml/schema/xsDateTime-nofractional.xml";
        this.expectedValue = this.expectedValue.withMillisOfSecond(0);
        Document document = parserPool.parse(XSDateTimeTest.class.getResourceAsStream(testDocumentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        XSDateTime xsDateTime = (XSDateTime)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertEquals((Object)xsDateTime.getElementQName(), (Object)this.expectedXMLObjectQName, (String)"Unexpected XSDate QName");
        Assert.assertEquals((Object)xsDateTime.getSchemaType(), (Object)XSDateTime.TYPE_NAME, (String)"Unexpected XSDateTime schema type");
        Assert.assertEquals((Object)xsDateTime.getValue().withChronology((Chronology)ISOChronology.getInstanceUTC()), (Object)this.expectedValue, (String)"Unexpected value of XSDateTime");
    }
}

