/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.schema;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class XSBooleanTest
extends XMLObjectBaseTestCase {
    private String testDocumentLocation;
    private QName expectedXMLObjectQName;
    private String expectedValue;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.testDocumentLocation = "/org/opensaml/core/xml/schema/xsBoolean.xml";
        this.expectedXMLObjectQName = new QName("urn:example.org:foo", "bar", "foo");
        this.expectedValue = "true";
    }

    @Test
    public void testMarshall() throws MarshallingException, XMLParserException {
        XMLObjectBuilder xsbBuilder = builderFactory.getBuilderOrThrow(XSBoolean.TYPE_NAME);
        XSBoolean xsBoolean = (XSBoolean)xsbBuilder.buildObject(this.expectedXMLObjectQName, XSBoolean.TYPE_NAME);
        xsBoolean.setValue(XSBooleanValue.valueOf((String)this.expectedValue));
        Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)xsBoolean);
        marshaller.marshall((XMLObject)xsBoolean);
        Document document = parserPool.parse(XSBooleanTest.class.getResourceAsStream(this.testDocumentLocation));
        this.assertXMLEquals("Marshalled XSBoolean does not match example document", document, (XMLObject)xsBoolean);
    }

    @Test
    public void testUnmarshall() throws XMLParserException, UnmarshallingException {
        Document document = parserPool.parse(XSBooleanTest.class.getResourceAsStream(this.testDocumentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        XSBoolean xsBoolean = (XSBoolean)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertEquals((Object)xsBoolean.getElementQName(), (Object)this.expectedXMLObjectQName, (String)"Unexpected XSBoolean QName");
        Assert.assertEquals((Object)xsBoolean.getSchemaType(), (Object)XSBoolean.TYPE_NAME, (String)"Unexpected XSBoolean schema type");
        Assert.assertEquals((String)this.expectedValue, (String)xsBoolean.getValue().toString(), (String)"Unexpected value of XSBoolean");
    }
}

