/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.schema;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSBase64Binary;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class XSBase64BinaryTest
extends XMLObjectBaseTestCase {
    private String testDocumentLocation;
    private QName expectedXMLObjectQName;
    private String expectedValue;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.testDocumentLocation = "/org/opensaml/core/xml/schema/xsBase64Binary.xml";
        this.expectedXMLObjectQName = new QName("urn:example.org:foo", "bar", "foo");
        this.expectedValue = "abcdABCDE===";
    }

    @Test
    public void testMarshall() throws MarshallingException, XMLParserException {
        XMLObjectBuilder xsb64bBuilder = builderFactory.getBuilderOrThrow(XSBase64Binary.TYPE_NAME);
        XSBase64Binary xsb64b = (XSBase64Binary)xsb64bBuilder.buildObject(this.expectedXMLObjectQName, XSBase64Binary.TYPE_NAME);
        xsb64b.setValue(this.expectedValue);
        Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)xsb64b);
        marshaller.marshall((XMLObject)xsb64b);
        Document document = parserPool.parse(XSBase64BinaryTest.class.getResourceAsStream(this.testDocumentLocation));
        this.assertXMLEquals("Marshalled XSBase64Binary does not match example document", document, (XMLObject)xsb64b);
    }

    @Test
    public void testUnmarshall() throws XMLParserException, UnmarshallingException {
        Document document = parserPool.parse(XSBase64BinaryTest.class.getResourceAsStream(this.testDocumentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        XSBase64Binary xsb64b = (XSBase64Binary)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertEquals((Object)xsb64b.getElementQName(), (Object)this.expectedXMLObjectQName, (String)"Unexpected XSBase64Binary QName");
        Assert.assertEquals((Object)xsb64b.getSchemaType(), (Object)XSBase64Binary.TYPE_NAME, (String)"Unexpected XSBase64Binary schema type");
        Assert.assertEquals((String)this.expectedValue, (String)xsb64b.getValue(), (String)"Unexpected value of XSBase64Binary");
    }
}

