/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml;

import java.util.Objects;
import java.util.Set;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.Namespace;
import org.opensaml.core.xml.NamespaceManager;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.schema.XSAny;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class NamespaceManagerTest
extends XMLObjectBaseTestCase {
    private XSAny xsAny;
    private NamespaceManager nsManager;
    private static String ns1uri = "urn:test:ns1uri";
    private static String ns1Prefix = "testNS1";
    private static String ns2uri = "urn:test:ns2uri";
    private static String ns2Prefix = "testNS2";
    private static String ns3uri = "urn:test:ns3uri";
    private static String ns3Prefix = "testNS3";
    private static String ns4uri = "urn:test:ns4uri";
    private static String ns4Prefix = "testNS4";
    private static QName elementName = new QName(ns1uri, "TestElementName", ns1Prefix);
    private static QName typeName = new QName(ns2uri, "TestTypeName", ns2Prefix);
    private static QName xsiTypeName = new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi");
    private XMLObjectBuilder<XSAny> xsAnyBuilder;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.xsAnyBuilder = builderFactory.getBuilderOrThrow(XSAny.TYPE_NAME);
        this.xsAny = (XSAny)this.xsAnyBuilder.buildObject(elementName);
        this.nsManager = this.xsAny.getNamespaceManager();
    }

    @Test
    public void testObjectName() {
        this.checkNamespaces((XMLObject)this.xsAny, 1, elementName);
    }

    @Test
    public void testObjectType() {
        this.xsAny = (XSAny)this.xsAnyBuilder.buildObject(elementName, typeName);
        this.checkNamespaces((XMLObject)this.xsAny, 3, elementName, typeName, xsiTypeName);
    }

    @Test
    public void testQNameElementContent() {
        QName content = new QName(ns2uri, "TestElementContent", ns2Prefix);
        this.nsManager.registerContentValue(content);
        this.checkNamespaces((XMLObject)this.xsAny, 2, elementName, content);
        this.nsManager.deregisterContentValue();
        this.checkNamespaces((XMLObject)this.xsAny, 1, elementName);
    }

    @Test
    public void testQualifiedAttributes() {
        QName attrName1 = new QName(ns1uri, "Attr1", ns1Prefix);
        QName attrName2 = new QName(ns2uri, "Attr2", ns2Prefix);
        QName attrName3 = new QName(ns3uri, "Attr3", ns3Prefix);
        this.nsManager.registerAttributeName(attrName1);
        this.checkNamespaces((XMLObject)this.xsAny, 1, elementName, attrName1);
        this.nsManager.registerAttributeName(attrName2);
        this.nsManager.registerAttributeName(attrName3);
        this.checkNamespaces((XMLObject)this.xsAny, 3, elementName, attrName1, attrName2, attrName3);
        this.nsManager.deregisterAttributeName(attrName2);
        this.checkNamespaces((XMLObject)this.xsAny, 2, elementName, attrName1, attrName3);
        this.nsManager.deregisterAttributeName(attrName1);
        this.nsManager.deregisterAttributeName(attrName3);
        this.checkNamespaces((XMLObject)this.xsAny, 1, elementName);
    }

    @Test
    public void testQNameAttributeValue() {
        QName attrName = new QName(ns1uri, "Attr1", ns1Prefix);
        QName attrValue1 = new QName(ns2uri, "Attr2", ns2Prefix);
        QName attrValue2 = new QName(ns3uri, "Attr3", ns3Prefix);
        this.nsManager.registerAttributeValue(NamespaceManager.generateAttributeID((QName)attrName), attrValue1);
        this.checkNamespaces((XMLObject)this.xsAny, 2, elementName, attrValue1);
        this.nsManager.registerAttributeValue(NamespaceManager.generateAttributeID((QName)attrName), attrValue2);
        this.checkNamespaces((XMLObject)this.xsAny, 2, elementName, attrValue2);
        this.nsManager.deregisterAttributeValue(NamespaceManager.generateAttributeID((QName)attrName));
        this.checkNamespaces((XMLObject)this.xsAny, 1, elementName);
    }

    @Test
    public void testNSDeclaration() {
        Namespace ns1 = new Namespace(ns1uri, ns1Prefix);
        Namespace ns2 = new Namespace(ns2uri, ns2Prefix);
        Assert.assertNotNull((Object)this.findNamespace(this.nsManager, ns1));
        Assert.assertEquals((int)this.nsManager.getNamespaces().size(), (int)1);
        Assert.assertFalse((boolean)this.nsManager.getNamespaceDeclarations().contains(ns1));
        this.nsManager.registerNamespaceDeclaration(ns1);
        Assert.assertEquals((int)this.nsManager.getNamespaces().size(), (int)1);
        Assert.assertNotNull((Object)this.findNamespace(this.nsManager, ns1));
        Assert.assertTrue((boolean)this.nsManager.getNamespaceDeclarations().contains(ns1));
        this.nsManager.registerNamespaceDeclaration(ns2);
        Assert.assertEquals((int)this.nsManager.getNamespaces().size(), (int)2);
        Assert.assertNotNull((Object)this.findNamespace(this.nsManager, ns2));
        Assert.assertTrue((boolean)this.nsManager.getNamespaceDeclarations().contains(ns2));
        this.nsManager.deregisterNamespaceDeclaration(ns1);
        Assert.assertEquals((int)this.nsManager.getNamespaces().size(), (int)2);
        Assert.assertNotNull((Object)this.findNamespace(this.nsManager, ns1));
        Assert.assertFalse((boolean)this.nsManager.getNamespaceDeclarations().contains(ns1));
        this.nsManager.deregisterNamespaceDeclaration(ns2);
        Assert.assertEquals((int)this.nsManager.getNamespaces().size(), (int)1);
        Assert.assertNull((Object)this.findNamespace(this.nsManager, ns2));
    }

    @Test
    public void testNonVisibleNamespacePrefixes() {
        QName name1 = new QName(ns1uri, "Test1", ns1Prefix);
        QName name2 = new QName(ns2uri, "Test2", ns2Prefix);
        QName name3 = new QName(ns3uri, "Test3", ns3Prefix);
        QName name4 = new QName(ns4uri, "Test4", ns4Prefix);
        Namespace ns = new Namespace(ns3uri, ns3Prefix);
        this.checkPrefixes(this.nsManager, new String[0]);
        this.nsManager.registerAttributeName(name1);
        this.checkPrefixes(this.nsManager, new String[0]);
        this.nsManager.deregisterAttributeName(name1);
        this.nsManager.registerAttributeValue("foo", name1);
        this.checkPrefixes(this.nsManager, new String[0]);
        this.nsManager.deregisterAttributeValue("foo");
        this.nsManager.registerAttributeName(name2);
        this.checkPrefixes(this.nsManager, new String[0]);
        this.nsManager.deregisterAttributeName(name2);
        this.nsManager.registerAttributeValue("foo", name2);
        this.checkPrefixes(this.nsManager, ns2Prefix);
        this.nsManager.registerContentValue(name3);
        this.checkPrefixes(this.nsManager, ns2Prefix, ns3Prefix);
        this.nsManager.deregisterAttributeValue("foo");
        this.nsManager.deregisterContentValue();
        this.checkPrefixes(this.nsManager, new String[0]);
        this.nsManager.registerNamespaceDeclaration(ns);
        this.checkPrefixes(this.nsManager, new String[0]);
        this.nsManager.deregisterNamespaceDeclaration(ns);
        this.checkPrefixes(this.nsManager, new String[0]);
        XSAny typedXSAny = (XSAny)this.xsAnyBuilder.buildObject(elementName, typeName);
        this.checkPrefixes(typedXSAny.getNamespaceManager(), ns2Prefix);
        typedXSAny.getUnknownAttributes().put(name4, name3);
        this.checkPrefixes(typedXSAny.getNamespaceManager(), ns2Prefix, ns3Prefix);
        typedXSAny.getUnknownAttributes().put(name2, name3);
        this.checkPrefixes(typedXSAny.getNamespaceManager(), ns3Prefix);
        typedXSAny.getUnknownAttributes().remove((Object)name2);
        this.checkPrefixes(typedXSAny.getNamespaceManager(), ns2Prefix, ns3Prefix);
        this.xsAny.getUnknownXMLObjects().add(typedXSAny);
        this.checkPrefixes(this.nsManager, ns2Prefix, ns3Prefix);
        this.xsAny.getUnknownAttributes().put(name2, "foo");
        this.checkPrefixes(this.nsManager, ns3Prefix);
    }

    private void checkPrefixes(NamespaceManager manager, String ... controlPrefixes) {
        Set nonVisiblePrefixes = manager.getNonVisibleNamespacePrefixes();
        Assert.assertEquals((int)nonVisiblePrefixes.size(), (int)controlPrefixes.length, (String)"Wrong number of not visible prefixes");
        for (String prefix : controlPrefixes) {
            Assert.assertTrue((boolean)nonVisiblePrefixes.contains(prefix), (String)("Expected prefix not seen: " + prefix));
        }
    }

    private void checkNamespaces(XMLObject xo, Integer nsSize, QName ... names) {
        Set namespacesPresent = xo.getNamespaces();
        if (nsSize != null) {
            int size = nsSize;
            Assert.assertEquals((int)xo.getNamespaces().size(), (int)size, (String)"Wrong number of unique namespaces");
        }
        block0: for (QName name : names) {
            Namespace nsExpected = this.buildNamespace(name);
            for (Namespace nsPresent : namespacesPresent) {
                if (!this.equals(nsExpected, nsPresent)) continue;
                continue block0;
            }
            Assert.fail((String)("Did not find expected namespace in object from QName: " + name.toString()));
        }
    }

    private Namespace buildNamespace(QName name) {
        String uri = StringSupport.trimOrNull((String)name.getNamespaceURI());
        if (uri == null) {
            throw new IllegalArgumentException("A non-empty namespace URI must be supplied");
        }
        String prefix = StringSupport.trimOrNull((String)name.getPrefix());
        return new Namespace(uri, prefix);
    }

    private boolean equals(Namespace ns1, Namespace ns2) {
        return Objects.equals(ns1.getNamespaceURI(), ns2.getNamespaceURI()) && Objects.equals(ns1.getNamespacePrefix(), ns2.getNamespacePrefix());
    }

    private Namespace findNamespace(NamespaceManager manager, Namespace ns) {
        for (Namespace namespace : manager.getNamespaces()) {
            if (!this.equals(namespace, ns)) continue;
            return namespace;
        }
        return null;
    }
}

