/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLAssertTestNG;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.custommonkey.xmlunit.Diff;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObjectBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MarshallingTest
extends XMLObjectBaseTestCase {
    private QName simpleXMLObjectQName = new QName("http://www.example.org/testObjects", "SimpleElement");

    @Test
    public void testMarshallingWithAttributes() throws XMLParserException {
        String expectedId = "Firefly";
        String expectedDocumentLocation = "/org/opensaml/core/xml/SimpleXMLObjectWithAttribute.xml";
        Document expectedDocument = parserPool.parse(MarshallingTest.class.getResourceAsStream(expectedDocumentLocation));
        SimpleXMLObjectBuilder sxoBuilder = (SimpleXMLObjectBuilder)builderFactory.getBuilder(this.simpleXMLObjectQName);
        SimpleXMLObject sxObject = sxoBuilder.buildObject();
        sxObject.setId(expectedId);
        this.assertXMLEquals(expectedDocument, (XMLObject)sxObject);
        Assert.assertNotNull((Object)sxObject.getDOM(), (String)"DOM was not cached after marshalling");
    }

    @Test
    public void testMarshallingWithElementContent() throws XMLParserException {
        String expectedDocumentLocation = "/org/opensaml/core/xml/SimpleXMLObjectWithContent.xml";
        Document expectedDocument = parserPool.parse(MarshallingTest.class.getResourceAsStream(expectedDocumentLocation));
        SimpleXMLObjectBuilder sxoBuilder = (SimpleXMLObjectBuilder)builderFactory.getBuilder(this.simpleXMLObjectQName);
        SimpleXMLObject sxObject = sxoBuilder.buildObject();
        SimpleXMLObject child1 = sxoBuilder.buildObject();
        child1.setValue("Content1");
        sxObject.getSimpleXMLObjects().add(child1);
        SimpleXMLObject child2 = sxoBuilder.buildObject();
        child2.setValue("Content2");
        sxObject.getSimpleXMLObjects().add(child2);
        SimpleXMLObject child3 = sxoBuilder.buildObject();
        sxObject.getSimpleXMLObjects().add(child3);
        SimpleXMLObject grandchild1 = sxoBuilder.buildObject();
        grandchild1.setValue("Content3");
        child3.getSimpleXMLObjects().add(grandchild1);
        this.assertXMLEquals(expectedDocument, (XMLObject)sxObject);
        Assert.assertNotNull((Object)sxObject.getDOM(), (String)"DOM was not cached after marshalling");
    }

    @Test
    public void testMarshallingWithChildElements() throws XMLParserException, MarshallingException {
        String expectedDocumentLocation = "/org/opensaml/core/xml/SimpleXMLObjectWithChildren.xml";
        Document expectedDocument = parserPool.parse(MarshallingTest.class.getResourceAsStream(expectedDocumentLocation));
        SimpleXMLObjectBuilder sxoBuilder = (SimpleXMLObjectBuilder)builderFactory.getBuilder(this.simpleXMLObjectQName);
        SimpleXMLObject sxObject = sxoBuilder.buildObject();
        SimpleXMLObject sxObjectChild1 = sxoBuilder.buildObject();
        SimpleXMLObject sxObjectChild2 = sxoBuilder.buildObject();
        sxObject.getSimpleXMLObjects().add(sxObjectChild1);
        sxObject.getSimpleXMLObjects().add(sxObjectChild2);
        this.assertXMLEquals(expectedDocument, (XMLObject)sxObject);
        Assert.assertNotNull((Object)sxObject.getDOM(), (String)"DOM was not cached after marshalling");
    }

    @Test
    public void testMarshallingXMLFragment() throws XMLParserException, MarshallingException {
        String expectedDocumentLocation = "/org/opensaml/core/xml/SOAPMessageWithContent.xml";
        String soapDocLocation = "/org/opensaml/core/xml/SOAPMessage.xml";
        Document soapDoc = parserPool.parse(MarshallingTest.class.getResourceAsStream(soapDocLocation));
        Element soapBody = (Element)soapDoc.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body").item(0);
        SimpleXMLObjectBuilder sxoBuilder = (SimpleXMLObjectBuilder)builderFactory.getBuilder(this.simpleXMLObjectQName);
        SimpleXMLObject response = sxoBuilder.buildObject("http://www.example.org/testObjects", "Response", "test");
        SimpleXMLObject statement = sxoBuilder.buildObject("http://www.example.org/testObjects", "Statement", "test");
        response.getSimpleXMLObjects().add(statement);
        Marshaller marshaller = marshallerFactory.getMarshaller(this.simpleXMLObjectQName);
        marshaller.marshall((XMLObject)response);
        Assert.assertNotNull((Object)response.getDOM(), (String)"DOM was not cached after marshalling");
        Document expectedDocument = parserPool.parse(MarshallingTest.class.getResourceAsStream(expectedDocumentLocation));
        Element statementElem = marshaller.marshall((XMLObject)statement, soapBody);
        XMLAssertTestNG.assertXMLIdentical((Diff)new Diff(expectedDocument, statementElem.getOwnerDocument()), (boolean)true);
        Assert.assertNull((Object)response.getDOM(), (String)"Parent of XML fragment DOM was not invalidated during marshalling");
        Assert.assertNotNull((Object)statement.getDOM(), (String)"XML fragment DOM was invalidated during marshalling");
    }

    @Test
    public void testMarshallingExistingEmptyDocument() throws XMLParserException, MarshallingException {
        Document document = parserPool.newDocument();
        Assert.assertNull((Object)document.getDocumentElement(), (String)"Incorrect document root");
        SimpleXMLObject sxo = (SimpleXMLObject)((Object)this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        sxo.setId("idValue");
        marshallerFactory.getMarshaller((XMLObject)sxo).marshall((XMLObject)sxo, document);
        Assert.assertNotNull((Object)document.getDocumentElement(), (String)"Incorrect document root");
        Assert.assertTrue((boolean)document.getDocumentElement().isSameNode(sxo.getDOM()), (String)"Incorrect document root");
    }

    @Test
    public void testMarshallingReplaceDocumentRoot() throws XMLParserException, MarshallingException {
        Document document = parserPool.newDocument();
        Element element = document.createElementNS(null, "Foo");
        document.appendChild(element);
        Assert.assertTrue((boolean)document.getDocumentElement().isSameNode(element), (String)"Incorrect document root");
        SimpleXMLObject sxo = (SimpleXMLObject)((Object)this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        sxo.setId("idValue");
        marshallerFactory.getMarshaller((XMLObject)sxo).marshall((XMLObject)sxo, document);
        Assert.assertFalse((boolean)document.getDocumentElement().isSameNode(element), (String)"Document root should have been replaced");
        Assert.assertTrue((boolean)document.getDocumentElement().isSameNode(sxo.getDOM()), (String)"Incorrect document root");
    }
}

