/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml;

import java.util.HashMap;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class IDAttributeTest
extends XMLObjectBaseTestCase {
    @Test
    public void testSimpleUnmarshall() {
        SimpleXMLObject sxObject = (SimpleXMLObject)((Object)this.unmarshallElement("/org/opensaml/core/xml/IDAttribute.xml"));
        Assert.assertEquals((Object)sxObject.resolveID("IDLevel1"), (Object)((Object)sxObject), (String)"ID lookup failed");
        Assert.assertEquals((Object)sxObject.resolveIDFromRoot("IDLevel1"), (Object)((Object)sxObject), (String)"ID lookup failed");
        Assert.assertNull((Object)sxObject.resolveID("NonExistent"), (String)"Lookup of non-existent ID didn't return null");
        sxObject.setId(null);
        Assert.assertNull((Object)sxObject.resolveID("IDLevel1"), (String)"Lookup of removed ID (formerly extant) didn't return null");
        Assert.assertNull((Object)sxObject.resolveIDFromRoot("IDLevel1"), (String)"Lookup of removed ID (formerly extant) didn't return null");
    }

    @Test
    public void testComplexUnmarshallInList() {
        SimpleXMLObject sxObject = (SimpleXMLObject)((Object)this.unmarshallElement("/org/opensaml/core/xml/IDAttributeWithChildrenList.xml"));
        Assert.assertNull((Object)sxObject.resolveID("NonExistent"), (String)"Lookup of non-existent ID didn't return null");
        Assert.assertNull((Object)sxObject.resolveIDFromRoot("NonExistent"), (String)"Lookup of non-existent ID didn't return null");
        Assert.assertEquals((Object)sxObject.resolveID("IDLevel1"), (Object)((Object)sxObject), (String)"ID lookup failed");
        Assert.assertEquals((Object)sxObject.resolveID("IDLevel2A"), (Object)((Object)sxObject.getSimpleXMLObjects().get(0)), (String)"ID lookup failed");
        Assert.assertEquals((Object)sxObject.resolveID("IDLevel2B"), (Object)((Object)sxObject.getSimpleXMLObjects().get(1)), (String)"ID lookup failed");
        Assert.assertEquals((Object)sxObject.resolveID("IDLevel2C"), (Object)((Object)sxObject.getSimpleXMLObjects().get(3)), (String)"ID lookup failed");
        Assert.assertEquals((Object)sxObject.resolveID("IDLevel3A"), (Object)((Object)sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(0)), (String)"ID lookup failed");
        Assert.assertEquals((Object)sxObject.resolveID("IDLevel3B"), (Object)((Object)sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(2)), (String)"ID lookup failed");
        Assert.assertEquals((Object)sxObject.resolveID("IDLevel3C"), (Object)((Object)sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(3)), (String)"ID lookup failed");
        Assert.assertEquals((Object)sxObject.resolveID("IDLevel4A"), (Object)((Object)sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(0)), (String)"ID lookup failed");
        Assert.assertEquals((Object)sxObject.getSimpleXMLObjects().get(0).resolveID("IDLevel2A"), (Object)((Object)sxObject.getSimpleXMLObjects().get(0)), (String)"ID lookup failed");
        Assert.assertEquals((Object)sxObject.getSimpleXMLObjects().get(0).resolveID("IDLevel3A"), (Object)((Object)sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(0)), (String)"ID lookup failed");
        Assert.assertEquals((Object)sxObject.getSimpleXMLObjects().get(0).resolveID("IDLevel3B"), (Object)((Object)sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(2)), (String)"ID lookup failed");
        Assert.assertEquals((Object)sxObject.getSimpleXMLObjects().get(0).resolveID("IDLevel3C"), (Object)((Object)sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(3)), (String)"ID lookup failed");
        Assert.assertEquals((Object)sxObject.getSimpleXMLObjects().get(0).resolveID("IDLevel4A"), (Object)((Object)sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(0)), (String)"ID lookup failed");
        Assert.assertNull((Object)sxObject.getSimpleXMLObjects().get(0).resolveID("IDLevel1"), (String)"Lookup of non-existent ID didn't return null");
        SimpleXMLObject sxoIDLevel4A = sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(0);
        SimpleXMLObject sxoIDLevel2C = sxObject.getSimpleXMLObjects().get(3);
        Assert.assertEquals((Object)sxoIDLevel4A.resolveIDFromRoot("IDLevel2C"), (Object)((Object)sxoIDLevel2C), (String)"ID lookup failed");
    }

    @Test
    public void testChangePropagationInList() {
        SimpleXMLObject sxObject = (SimpleXMLObject)((Object)this.unmarshallElement("/org/opensaml/core/xml/IDAttributeWithChildrenList.xml"));
        sxObject.getSimpleXMLObjects().get(1).setId("NewIDLevel2B");
        Assert.assertEquals((Object)sxObject.resolveID("NewIDLevel2B"), (Object)((Object)sxObject.getSimpleXMLObjects().get(1)), (String)"ID lookup failed");
        Assert.assertNull((Object)sxObject.resolveID("IDLevel2B"), (String)"Lookup of non-existent ID didn't return null");
        sxObject.getSimpleXMLObjects().get(1).setId(null);
        Assert.assertNull((Object)sxObject.resolveID("NewIDLevel2B"), (String)"Lookup of non-existent ID didn't return null");
        Assert.assertNull((Object)sxObject.resolveID("IDLevel2B"), (String)"Lookup of non-existent ID didn't return null");
        sxObject.getSimpleXMLObjects().get(1).setId("IDLevel2B");
        Assert.assertEquals((Object)sxObject.resolveID("IDLevel2B"), (Object)((Object)sxObject.getSimpleXMLObjects().get(1)), (String)"ID lookup failed");
        Assert.assertNull((Object)sxObject.resolveID("NewIDLevel2B"), (String)"Lookup of non-existent ID didn't return null");
        sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(3).setId("NewIDLevel3C");
        Assert.assertEquals((Object)sxObject.resolveID("NewIDLevel3C"), (Object)((Object)sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(3)), (String)"ID lookup failed");
        Assert.assertNull((Object)sxObject.resolveID("IDLevel3C"), (String)"Lookup of non-existent ID didn't return null");
        sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(0).setId(null);
        Assert.assertNull((Object)sxObject.resolveID("IDLevel3A"), (String)"Lookup of non-existent ID didn't return null");
        sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(0).setId("IDLevel3A");
        Assert.assertEquals((Object)sxObject.resolveID("IDLevel3A"), (Object)((Object)sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(0)), (String)"ID lookup failed");
    }

    @Test
    public void testListOpChangePropagation() {
        SimpleXMLObject sxObject = (SimpleXMLObject)((Object)this.unmarshallElement("/org/opensaml/core/xml/IDAttributeWithChildrenList.xml"));
        SimpleXMLObject targetIDLevel3B = sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().get(2);
        Assert.assertEquals((Object)sxObject.resolveID("IDLevel3B"), (Object)((Object)targetIDLevel3B), (String)"ID lookup failed");
        sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().remove(2);
        Assert.assertNull((Object)sxObject.resolveID("IDLevel3B"), (String)"Lookup of non-existent ID didn't return null");
        sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().add(targetIDLevel3B);
        Assert.assertEquals((Object)sxObject.resolveID("IDLevel3B"), (Object)((Object)targetIDLevel3B), (String)"ID lookup failed");
        sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().remove((Object)targetIDLevel3B);
        Assert.assertNull((Object)sxObject.resolveID("IDLevel3B"), (String)"Lookup of non-existent ID didn't return null");
        sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().set(1, targetIDLevel3B);
        Assert.assertEquals((Object)sxObject.resolveID("IDLevel3B"), (Object)((Object)targetIDLevel3B), (String)"ID lookup failed");
        sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().remove((Object)targetIDLevel3B);
        Assert.assertNull((Object)sxObject.resolveID("IDLevel3B"), (String)"Lookup of non-existent ID didn't return null");
        SimpleXMLObject newSimpleObject = (SimpleXMLObject)((Object)this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        newSimpleObject.setId("NewSimpleElement");
        sxObject.getSimpleXMLObjects().get(3).getSimpleXMLObjects().add(newSimpleObject);
        Assert.assertEquals((Object)sxObject.resolveID("NewSimpleElement"), (Object)((Object)newSimpleObject), (String)"ID lookup failed");
        sxObject.getSimpleXMLObjects().get(3).getSimpleXMLObjects().remove((Object)newSimpleObject);
        Assert.assertNull((Object)sxObject.resolveID("NewSimpleElement"), (String)"Lookup of non-existent ID didn't return null");
        sxObject.getSimpleXMLObjects().get(0).getSimpleXMLObjects().clear();
        Assert.assertNull((Object)sxObject.resolveID("IDLevel3A"), (String)"Lookup of non-existent ID didn't return null");
        Assert.assertNull((Object)sxObject.resolveID("IDLevel3B"), (String)"Lookup of non-existent ID didn't return null");
        Assert.assertNull((Object)sxObject.resolveID("IDLevel3C"), (String)"Lookup of non-existent ID didn't return null");
        Assert.assertNull((Object)sxObject.resolveID("IDLevel4A"), (String)"Lookup of non-existent ID didn't return null");
    }

    @Test
    public void testAttributeMap() throws XMLParserException, UnmarshallingException {
        String documentLocation = "/org/opensaml/core/xml/IDAttributeWithAttributeMap.xml";
        Document document = parserPool.parse(IDAttributeTest.class.getResourceAsStream(documentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(XMLObjectProviderRegistrySupport.getDefaultProviderQName());
        XMLObject xmlobject = unmarshaller.unmarshall(document.getDocumentElement());
        XSAny epParent = (XSAny)xmlobject;
        Assert.assertNotNull((Object)epParent, (String)"Cast of parent to XSAny failed");
        XSAny epChild0 = (XSAny)epParent.getUnknownXMLObjects().get(0);
        Assert.assertNotNull((Object)epChild0, (String)"Cast of child 0 to XSAny failed");
        XSAny epChild1 = (XSAny)epParent.getUnknownXMLObjects().get(1);
        Assert.assertNotNull((Object)epChild1, (String)"Cast of child 1 to XSAny failed");
        Assert.assertNull((Object)epParent.resolveID("1144"), (String)"Lookup of non-existent ID mapping didn't return null");
        Assert.assertNull((Object)epParent.resolveID("1166"), (String)"Lookup of non-existent ID mapping didn't return null");
        QName idName = QNameSupport.constructQName(null, (String)"id", null);
        epChild0.getUnknownAttributes().registerID(idName);
        Assert.assertEquals((Object)epParent.resolveID("1144"), (Object)epChild0, (String)"Lookup of ID mapping failed");
        Assert.assertNull((Object)epChild1.resolveID("1144"), (String)"Lookup of non-existent ID mapping didn't return null");
        Assert.assertEquals((Object)epChild1.resolveIDFromRoot("1144"), (Object)epChild0, (String)"Lookup of ID mapping failed");
    }

    @Test
    public void testAttributeMapOps() throws XMLParserException, UnmarshallingException {
        String documentLocation = "/org/opensaml/core/xml/IDAttributeWithAttributeMap.xml";
        Document document = parserPool.parse(IDAttributeTest.class.getResourceAsStream(documentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(XMLObjectProviderRegistrySupport.getDefaultProviderQName());
        XMLObject xmlobject = unmarshaller.unmarshall(document.getDocumentElement());
        XSAny epParent = (XSAny)xmlobject;
        Assert.assertNotNull((Object)epParent, (String)"Cast of parent to XSAny failed");
        XSAny epChild0 = (XSAny)epParent.getUnknownXMLObjects().get(0);
        Assert.assertNotNull((Object)epChild0, (String)"Cast of child 0 to XSAny failed");
        QName idName = QNameSupport.constructQName(null, (String)"id", null);
        epChild0.getUnknownAttributes().registerID(idName);
        Assert.assertEquals((Object)epParent.resolveID("1144"), (Object)epChild0, (String)"Lookup of ID mapping failed");
        epChild0.getUnknownAttributes().put(idName, "9999");
        Assert.assertNull((Object)epParent.resolveID("1144"), (String)"Lookup of non-existent ID mapping didn't return null");
        Assert.assertEquals((Object)epParent.resolveID("9999"), (Object)epChild0, (String)"Lookup of ID mapping failed");
        epChild0.getUnknownAttributes().remove((Object)idName);
        Assert.assertNull((Object)epParent.resolveID("9999"), (String)"Lookup of non-existent ID mapping didn't return null");
        HashMap<QName, String> attribs = new HashMap<QName, String>();
        attribs.put(idName, "1967");
        epChild0.getUnknownAttributes().putAll(attribs);
        Assert.assertEquals((Object)epParent.resolveID("1967"), (Object)epChild0, (String)"Lookup of ID mapping failed");
        epChild0.getUnknownAttributes().clear();
        Assert.assertNull((Object)epParent.resolveID("1967"), (String)"Lookup of non-existent ID mapping didn't return null");
        epChild0.getUnknownAttributes().put(idName, "abc123");
        Assert.assertEquals((Object)epParent.resolveID("abc123"), (Object)epChild0, (String)"Lookup of ID mapping failed");
        epChild0.getUnknownAttributes().deregisterID(idName);
        Assert.assertNull((Object)epParent.resolveID("abc123"), (String)"Lookup of non-existent ID mapping didn't return null");
    }

    @Test
    public void testGlobalIDRegistration() throws XMLParserException, UnmarshallingException {
        QName attribQName = new QName("http://www.example.org", "id", "test");
        String documentLocation = "/org/opensaml/core/xml/IDAttributeGlobal.xml";
        Document document = parserPool.parse(IDAttributeTest.class.getResourceAsStream(documentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(XMLObjectProviderRegistrySupport.getDefaultProviderQName());
        XMLObject xmlObject = unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertNull((Object)xmlObject.resolveID("GlobalID1"), (String)"Lookup of non-existent ID mapping didn't return null");
        Assert.assertNull((Object)xmlObject.resolveID("GlobalID2"), (String)"Lookup of non-existent ID mapping didn't return null");
        XMLObjectProviderRegistrySupport.registerIDAttribute((QName)attribQName);
        document = parserPool.parse(IDAttributeTest.class.getResourceAsStream(documentLocation));
        xmlObject = unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertEquals((Object)xmlObject.resolveID("GlobalID1"), (Object)xmlObject, (String)"Lookup of ID mapping failed");
        Assert.assertEquals((Object)xmlObject.resolveID("GlobalID2"), ((XSAny)xmlObject).getUnknownXMLObjects().get(0), (String)"Lookup of ID mapping failed");
        XMLObjectProviderRegistrySupport.deregisterIDAttribute((QName)attribQName);
        document = parserPool.parse(IDAttributeTest.class.getResourceAsStream(documentLocation));
        xmlObject = unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertNull((Object)xmlObject.resolveID("GlobalID1"), (String)"Lookup of non-existent ID mapping didn't return null");
        Assert.assertNull((Object)xmlObject.resolveID("GlobalID2"), (String)"Lookup of non-existent ID mapping didn't return null");
    }
}

