/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.config.provider;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.opensaml.core.config.ConfigurationPropertiesSource;
import org.opensaml.core.config.provider.AbstractFilesystemConfigurationPropertiesSource;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FilesystemConfigurationPropertiesSourceTest {
    private ConfigurationPropertiesSource source;
    private File masterFile = new File("src/test/resources/opensaml-config.properties");
    private File targetFile = File.createTempFile("opensaml-config.properties", "");

    public FilesystemConfigurationPropertiesSourceTest() throws IOException {
        System.out.println(this.masterFile.getAbsolutePath());
        System.out.println(this.targetFile.getAbsolutePath());
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        Files.copy((File)this.masterFile, (File)this.targetFile);
    }

    @AfterMethod
    protected void tearDown() throws Exception {
        if (this.targetFile.exists()) {
            this.targetFile.delete();
        }
    }

    @Test
    public void testSource() {
        this.source = new TestFilesystemConfigurationPropertiesSource();
        Properties props = this.source.getProperties();
        Assert.assertNotNull((Object)props, (String)"Properties was null");
        Assert.assertEquals((String)props.getProperty("opensaml.config.partitionName"), (String)"myapp", (String)"Incorrect property value");
        Assert.assertEquals((String)props.getProperty("opensaml.initializer.foo.flag"), (String)"true", (String)"Incorrect property value");
    }

    public class TestFilesystemConfigurationPropertiesSource
    extends AbstractFilesystemConfigurationPropertiesSource {
        protected String getFilename() {
            return FilesystemConfigurationPropertiesSourceTest.this.targetFile.getAbsolutePath();
        }
    }
}

