/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.errors;

import java.io.IOException;
import java.text.MessageFormat;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.AbbreviatedObjectId;
import org.openrewrite.jgit.lib.Constants;
import org.openrewrite.jgit.lib.ObjectId;

public class MissingObjectException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final ObjectId missing;

    public MissingObjectException(ObjectId id, String type) {
        super(MessageFormat.format(JGitText.get().missingObject, type, id.name()));
        this.missing = id.copy();
    }

    public MissingObjectException(ObjectId id, int type) {
        this(id, Constants.typeString(type));
    }

    public MissingObjectException(AbbreviatedObjectId id, int type) {
        super(MessageFormat.format(JGitText.get().missingObject, Constants.typeString(type), id.name()));
        this.missing = null;
    }

    public ObjectId getObjectId() {
        return this.missing;
    }
}

