/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.revwalk.filter;

import java.io.IOException;
import org.openrewrite.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.jgit.errors.MissingObjectException;
import org.openrewrite.jgit.errors.StopWalkException;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.revwalk.RevCommit;
import org.openrewrite.jgit.revwalk.RevWalk;
import org.openrewrite.jgit.revwalk.filter.RevFilter;

public class SkipRevFilter
extends RevFilter {
    private final int skip;
    private int count;

    public static RevFilter create(int skip) {
        if (skip < 0) {
            throw new IllegalArgumentException(JGitText.get().skipMustBeNonNegative);
        }
        return new SkipRevFilter(skip);
    }

    private SkipRevFilter(int skip) {
        this.skip = skip;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.skip <= this.count++;
    }

    @Override
    public RevFilter clone() {
        return new SkipRevFilter(this.skip);
    }
}

