/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.dircache;

import java.io.IOException;
import org.openrewrite.jgit.dircache.DirCacheBuilder;
import org.openrewrite.jgit.dircache.DirCacheIterator;
import org.openrewrite.jgit.dircache.DirCacheTree;
import org.openrewrite.jgit.errors.CorruptObjectException;
import org.openrewrite.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.jgit.lib.ObjectReader;
import org.openrewrite.jgit.treewalk.AbstractTreeIterator;

public class DirCacheBuildIterator
extends DirCacheIterator {
    private final DirCacheBuilder builder;

    public DirCacheBuildIterator(DirCacheBuilder dcb) {
        super(dcb.getDirCache());
        this.builder = dcb;
    }

    DirCacheBuildIterator(DirCacheBuildIterator p, DirCacheTree dct) {
        super(p, dct);
        this.builder = p.builder;
    }

    @Override
    public AbstractTreeIterator createSubtreeIterator(ObjectReader reader) throws IncorrectObjectTypeException, IOException {
        if (this.currentSubtree == null) {
            throw new IncorrectObjectTypeException(this.getEntryObjectId(), "tree");
        }
        return new DirCacheBuildIterator(this, this.currentSubtree);
    }

    @Override
    public void skip() throws CorruptObjectException {
        if (this.currentSubtree != null) {
            this.builder.keep(this.ptr, this.currentSubtree.getEntrySpan());
        } else {
            this.builder.keep(this.ptr, 1);
        }
        this.next(1);
    }

    @Override
    public void stopWalk() {
        int cur = this.ptr;
        int cnt = this.cache.getEntryCount();
        if (cur < cnt) {
            this.builder.keep(cur, cnt - cur);
        }
    }

    @Override
    protected boolean needsStopWalk() {
        return this.ptr < this.cache.getEntryCount();
    }
}

