/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.hooks;

import java.io.PrintStream;
import java.text.MessageFormat;
import org.openrewrite.jgit.hooks.CommitMsgHook;
import org.openrewrite.jgit.hooks.PostCommitHook;
import org.openrewrite.jgit.hooks.PreCommitHook;
import org.openrewrite.jgit.hooks.PrePushHook;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.util.LfsFactory;

public class Hooks {
    public static PreCommitHook preCommit(Repository repo, PrintStream outputStream) {
        return new PreCommitHook(repo, outputStream);
    }

    public static PreCommitHook preCommit(Repository repo, PrintStream outputStream, PrintStream errorStream) {
        return new PreCommitHook(repo, outputStream, errorStream);
    }

    public static PostCommitHook postCommit(Repository repo, PrintStream outputStream) {
        return new PostCommitHook(repo, outputStream);
    }

    public static PostCommitHook postCommit(Repository repo, PrintStream outputStream, PrintStream errorStream) {
        return new PostCommitHook(repo, outputStream, errorStream);
    }

    public static CommitMsgHook commitMsg(Repository repo, PrintStream outputStream) {
        return new CommitMsgHook(repo, outputStream);
    }

    public static CommitMsgHook commitMsg(Repository repo, PrintStream outputStream, PrintStream errorStream) {
        return new CommitMsgHook(repo, outputStream, errorStream);
    }

    public static PrePushHook prePush(Repository repo, PrintStream outputStream) {
        PrePushHook hook;
        if (LfsFactory.getInstance().isAvailable() && (hook = LfsFactory.getInstance().getPrePushHook(repo, outputStream)) != null) {
            if (hook.isNativeHookPresent()) {
                PrintStream ps = outputStream;
                if (ps == null) {
                    ps = System.out;
                }
                ps.println(MessageFormat.format(JGitText.get().lfsHookConflict, repo));
            }
            return hook;
        }
        return new PrePushHook(repo, outputStream);
    }

    public static PrePushHook prePush(Repository repo, PrintStream outputStream, PrintStream errorStream) {
        PrePushHook hook;
        if (LfsFactory.getInstance().isAvailable() && (hook = LfsFactory.getInstance().getPrePushHook(repo, outputStream, errorStream)) != null) {
            if (hook.isNativeHookPresent()) {
                PrintStream ps = outputStream;
                if (ps == null) {
                    ps = System.out;
                }
                ps.println(MessageFormat.format(JGitText.get().lfsHookConflict, repo));
            }
            return hook;
        }
        return new PrePushHook(repo, outputStream, errorStream);
    }
}

