/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.transport;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.jgit.storage.pack.PackStatistics;
import org.openrewrite.jgit.transport.PostUploadHook;

public class PostUploadHookChain
implements PostUploadHook {
    private final List<PostUploadHook> hooks;

    public static PostUploadHook newChain(List<PostUploadHook> hooks) {
        List<PostUploadHook> newHooks = hooks.stream().filter(hook -> !hook.equals(PostUploadHook.NULL)).collect(Collectors.toList());
        if (newHooks.isEmpty()) {
            return PostUploadHook.NULL;
        }
        if (newHooks.size() == 1) {
            return (PostUploadHook)newHooks.get(0);
        }
        return new PostUploadHookChain(newHooks);
    }

    @Override
    public void onPostUpload(PackStatistics stats) {
        for (PostUploadHook hook : this.hooks) {
            hook.onPostUpload(stats);
        }
    }

    private PostUploadHookChain(List<PostUploadHook> hooks) {
        this.hooks = Collections.unmodifiableList(hooks);
    }
}

