/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.transport;

import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.jgit.errors.TransportException;
import org.openrewrite.jgit.internal.transport.jsch.JSchText;
import org.openrewrite.jgit.transport.CredentialsProvider;
import org.openrewrite.jgit.transport.CredentialsProviderUserInfo;
import org.openrewrite.jgit.transport.JschSession;
import org.openrewrite.jgit.transport.OpenSshConfig;
import org.openrewrite.jgit.transport.RemoteSession;
import org.openrewrite.jgit.transport.SshSessionFactory;
import org.openrewrite.jgit.transport.URIish;
import org.openrewrite.jgit.util.FS;
import org.openrewrite.jgit.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JschConfigSessionFactory
extends SshSessionFactory {
    private static final String JSCH = "jsch";
    private static final Logger LOG = LoggerFactory.getLogger(JschConfigSessionFactory.class);
    private final Map<String, JSch> byIdentityFile = new HashMap<String, JSch>();
    private JSch defaultJSch;
    private OpenSshConfig config;

    public synchronized RemoteSession getSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
        String user = uri.getUser();
        String pass = uri.getPass();
        String host = uri.getHost();
        int port = uri.getPort();
        try {
            if (this.config == null) {
                this.config = OpenSshConfig.get(fs);
            }
            OpenSshConfig.Host hc = this.config.lookup(host);
            if (port <= 0) {
                port = hc.getPort();
            }
            if (user == null) {
                user = hc.getUser();
            }
            Session session = this.createSession(credentialsProvider, fs, user, pass, host, port, hc);
            int retries = 0;
            while (!session.isConnected()) {
                try {
                    ++retries;
                    session.connect(tms);
                }
                catch (JSchException e) {
                    session.disconnect();
                    session = null;
                    JschConfigSessionFactory.knownHosts(this.getJSch(hc, fs), fs);
                    if (JschConfigSessionFactory.isAuthenticationCanceled(e)) {
                        throw e;
                    }
                    if (JschConfigSessionFactory.isAuthenticationFailed(e) && credentialsProvider != null) {
                        if (retries < 3) {
                            credentialsProvider.reset(uri);
                            session = this.createSession(credentialsProvider, fs, user, pass, host, port, hc);
                            continue;
                        }
                        throw e;
                    }
                    if (retries >= hc.getConnectionAttempts()) {
                        throw e;
                    }
                    try {
                        Thread.sleep(1000L);
                        session = this.createSession(credentialsProvider, fs, user, pass, host, port, hc);
                    }
                    catch (InterruptedException e1) {
                        throw new TransportException(JSchText.get().transportSSHRetryInterrupt, (Throwable)e1);
                    }
                }
            }
            return new JschSession(session, uri);
        }
        catch (JSchException je) {
            Throwable c = je.getCause();
            if (c instanceof UnknownHostException) {
                throw new TransportException(uri, JSchText.get().unknownHost, (Throwable)je);
            }
            if (c instanceof ConnectException) {
                throw new TransportException(uri, c.getMessage(), (Throwable)je);
            }
            throw new TransportException(uri, je.getMessage(), (Throwable)je);
        }
    }

    public String getType() {
        return JSCH;
    }

    private static boolean isAuthenticationFailed(JSchException e) {
        return e.getCause() == null && e.getMessage().equals("Auth fail");
    }

    private static boolean isAuthenticationCanceled(JSchException e) {
        return e.getCause() == null && e.getMessage().equals("Auth cancel");
    }

    Session createSession(CredentialsProvider credentialsProvider, FS fs, String user, String pass, String host, int port, OpenSshConfig.Host hc) throws JSchException {
        String pauth;
        String strictHostKeyCheckingPolicy;
        Session session = this.createSession(hc, user, host, port, fs);
        this.setUserName(session, user);
        if (port > 0 && port != session.getPort()) {
            session.setPort(port);
        }
        session.setConfig("MaxAuthTries", "1");
        if (pass != null) {
            session.setPassword(pass);
        }
        if ((strictHostKeyCheckingPolicy = hc.getStrictHostKeyChecking()) != null) {
            session.setConfig("StrictHostKeyChecking", strictHostKeyCheckingPolicy);
        }
        if ((pauth = hc.getPreferredAuthentications()) != null) {
            session.setConfig("PreferredAuthentications", pauth);
        }
        if (!(credentialsProvider == null || hc.isBatchMode() && credentialsProvider.isInteractive())) {
            session.setUserInfo((UserInfo)new CredentialsProviderUserInfo(session, credentialsProvider));
        }
        this.safeConfig(session, hc.getConfig());
        if (hc.getConfig().getValue("HostKeyAlgorithms") == null) {
            JschConfigSessionFactory.setPreferredKeyTypesOrder(session);
        }
        this.configure(hc, session);
        return session;
    }

    private void safeConfig(Session session, ConfigRepository.Config cfg) {
        this.copyConfigValueToSession(session, cfg, "Ciphers", "CheckCiphers");
        this.copyConfigValueToSession(session, cfg, "KexAlgorithms", "CheckKexes");
        this.copyConfigValueToSession(session, cfg, "HostKeyAlgorithms", "CheckSignatures");
    }

    private static void setPreferredKeyTypesOrder(Session session) {
        HostKeyRepository hkr = session.getHostKeyRepository();
        HostKey[] hostKeys = hkr.getHostKey(JschConfigSessionFactory.hostName(session), null);
        if (hostKeys == null) {
            return;
        }
        List known = Stream.of(hostKeys).map(HostKey::getType).collect(Collectors.toList());
        if (!known.isEmpty()) {
            String serverHostKey = "server_host_key";
            String current = session.getConfig(serverHostKey);
            if (current == null) {
                session.setConfig(serverHostKey, String.join((CharSequence)",", known));
                return;
            }
            String knownFirst = Stream.concat(known.stream(), Stream.of(current.split(",")).filter(s -> !known.contains(s))).collect(Collectors.joining(","));
            session.setConfig(serverHostKey, knownFirst);
        }
    }

    private static String hostName(Session s) {
        if (s.getPort() == 22) {
            return s.getHost();
        }
        return String.format("[%s]:%d", s.getHost(), s.getPort());
    }

    private void copyConfigValueToSession(Session session, ConfigRepository.Config cfg, String from, String to) {
        String value = cfg.getValue(from);
        if (value != null) {
            session.setConfig(to, value);
        }
    }

    private void setUserName(Session session, String userName) {
        if (userName == null || userName.isEmpty() || userName.equals(session.getUserName())) {
            return;
        }
        try {
            Class[] parameterTypes = new Class[]{String.class};
            Method method = Session.class.getDeclaredMethod("setUserName", parameterTypes);
            method.setAccessible(true);
            method.invoke((Object)session, userName);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
            LOG.error(MessageFormat.format(JSchText.get().sshUserNameError, userName, session.getUserName()), (Throwable)e);
        }
    }

    protected Session createSession(OpenSshConfig.Host hc, String user, String host, int port, FS fs) throws JSchException {
        return this.getJSch(hc, fs).getSession(user, host, port);
    }

    protected void configureJSch(JSch jsch) {
    }

    protected void configure(OpenSshConfig.Host hc, Session session) {
    }

    protected JSch getJSch(OpenSshConfig.Host hc, FS fs) throws JSchException {
        File identityFile;
        if (this.defaultJSch == null) {
            this.defaultJSch = this.createDefaultJSch(fs);
            if (this.defaultJSch.getConfigRepository() == null) {
                this.defaultJSch.setConfigRepository((ConfigRepository)new JschBugFixingConfigRepository(this.config));
            }
            for (Object name : this.defaultJSch.getIdentityNames()) {
                this.byIdentityFile.put((String)name, this.defaultJSch);
            }
        }
        if ((identityFile = hc.getIdentityFile()) == null) {
            return this.defaultJSch;
        }
        String identityKey = identityFile.getAbsolutePath();
        JSch jsch = this.byIdentityFile.get(identityKey);
        if (jsch == null) {
            jsch = new JSch();
            this.configureJSch(jsch);
            if (jsch.getConfigRepository() == null) {
                jsch.setConfigRepository(this.defaultJSch.getConfigRepository());
            }
            jsch.setHostKeyRepository(this.defaultJSch.getHostKeyRepository());
            jsch.addIdentity(identityKey);
            this.byIdentityFile.put(identityKey, jsch);
        }
        return jsch;
    }

    protected JSch createDefaultJSch(FS fs) throws JSchException {
        JSch jsch = new JSch();
        this.copyGlobalConfigIfNotSet("signature.rsa", "ssh-rsa");
        this.copyGlobalConfigIfNotSet("signature.dss", "ssh-dss");
        this.configureJSch(jsch);
        JschConfigSessionFactory.knownHosts(jsch, fs);
        JschConfigSessionFactory.identities(jsch, fs);
        return jsch;
    }

    private void copyGlobalConfigIfNotSet(String from, String to) {
        String fromValue;
        String toValue = JSch.getConfig((String)to);
        if (StringUtils.isEmptyOrNull((String)toValue) && !StringUtils.isEmptyOrNull((String)(fromValue = JSch.getConfig((String)from)))) {
            JSch.setConfig((String)to, (String)fromValue);
        }
    }

    private static void knownHosts(JSch sch, FS fs) throws JSchException {
        File home = fs.userHome();
        if (home == null) {
            return;
        }
        File known_hosts = new File(new File(home, ".ssh"), "known_hosts");
        try (FileInputStream in = new FileInputStream(known_hosts);){
            sch.setKnownHosts((InputStream)in);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void identities(JSch sch, FS fs) {
        File home = fs.userHome();
        if (home == null) {
            return;
        }
        File sshdir = new File(home, ".ssh");
        if (sshdir.isDirectory()) {
            JschConfigSessionFactory.loadIdentity(sch, new File(sshdir, "identity"));
            JschConfigSessionFactory.loadIdentity(sch, new File(sshdir, "id_rsa"));
            JschConfigSessionFactory.loadIdentity(sch, new File(sshdir, "id_dsa"));
            JschConfigSessionFactory.loadIdentity(sch, new File(sshdir, "id_ecdsa"));
            JschConfigSessionFactory.loadIdentity(sch, new File(sshdir, "id_ed25519"));
            JschConfigSessionFactory.loadIdentity(sch, new File(sshdir, "id_ed448"));
        }
    }

    private static void loadIdentity(JSch sch, File priv) {
        if (priv.isFile()) {
            try {
                sch.addIdentity(priv.getAbsolutePath());
            }
            catch (JSchException jSchException) {
                // empty catch block
            }
        }
    }

    synchronized void setConfig(OpenSshConfig config) {
        this.config = config;
    }

    private static class JschBugFixingConfigRepository
    implements ConfigRepository {
        private final ConfigRepository base;

        public JschBugFixingConfigRepository(ConfigRepository base) {
            this.base = base;
        }

        public ConfigRepository.Config getConfig(String host) {
            return new JschBugFixingConfig(this.base.getConfig(host));
        }

        private static class JschBugFixingConfig
        implements ConfigRepository.Config {
            private static final String[] NO_IDENTITIES = new String[0];
            private final ConfigRepository.Config real;

            public JschBugFixingConfig(ConfigRepository.Config delegate) {
                this.real = delegate;
            }

            public String getHostname() {
                return this.real.getHostname();
            }

            public String getUser() {
                return this.real.getUser();
            }

            public int getPort() {
                return this.real.getPort();
            }

            public String getValue(String key) {
                String k = key.toUpperCase(Locale.ROOT);
                if ("IDENTITYFILE".equals(k)) {
                    return null;
                }
                String result = this.real.getValue(key);
                if (result != null && ("SERVERALIVEINTERVAL".equals(k) || "CONNECTTIMEOUT".equals(k))) {
                    try {
                        int timeout = Integer.parseInt(result);
                        result = Long.toString(TimeUnit.SECONDS.toMillis(timeout));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return result;
            }

            public String[] getValues(String key) {
                String k = key.toUpperCase(Locale.ROOT);
                if ("IDENTITYFILE".equals(k)) {
                    return NO_IDENTITIES;
                }
                return this.real.getValues(key);
            }
        }
    }
}

