/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.search;

import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class FindKey
extends Recipe {
    @Option(displayName="Path", description="A JsonPath expression used to find matching keys.", example="$.subjects.kind")
    private final String key;

    public String getDisplayName() {
        return "Find YAML entries";
    }

    public String getDescription() {
        return "Find YAML entries that match the specified [JsonPath](https://docs.openrewrite.org/reference/jsonpath-and-jsonpathmatcher-reference) expression.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher matcher = new JsonPathMatcher(this.key);
        return new YamlVisitor<ExecutionContext>(){

            @Override
            public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml.Mapping.Entry e = (Yaml.Mapping.Entry)super.visitMappingEntry(entry, ctx);
                if (matcher.matches(this.getCursor())) {
                    e = (Yaml.Mapping.Entry)SearchResult.found((Tree)e);
                }
                return e;
            }

            @Override
            public Yaml visitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
                Yaml.Mapping m = (Yaml.Mapping)super.visitMapping(mapping, ctx);
                if (matcher.matches(this.getCursor())) {
                    m = (Yaml.Mapping)SearchResult.found((Tree)m);
                }
                return m;
            }
        };
    }

    public static Set<Yaml> find(Yaml y, String jsonPath) {
        final JsonPathMatcher matcher = new JsonPathMatcher(jsonPath);
        return (Set)new YamlVisitor<Set<Yaml>>(){

            @Override
            public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, Set<Yaml> es) {
                Yaml.Mapping.Entry e = (Yaml.Mapping.Entry)super.visitMappingEntry(entry, es);
                if (matcher.matches(this.getCursor())) {
                    es.add(e);
                }
                return e;
            }

            @Override
            public Yaml visitMapping(Yaml.Mapping mapping, Set<Yaml> es) {
                Yaml.Mapping m = (Yaml.Mapping)super.visitMapping(mapping, es);
                if (matcher.matches(this.getCursor())) {
                    es.add(m);
                }
                return m;
            }
        }.reduce(y, new HashSet());
    }

    @Generated
    public FindKey(String key) {
        this.key = key;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindKey(key=" + this.getKey() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindKey)) {
            return false;
        }
        FindKey other = (FindKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }
}

