/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.MergeYamlVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.tree.Yaml;

public final class MergeYaml
extends Recipe {
    @Option(displayName="Key path", description="A [JsonPath](https://docs.openrewrite.org/reference/jsonpath-and-jsonpathmatcher-reference) expression used to find matching keys.", example="$.metadata")
    private final String key;
    @Option(displayName="YAML snippet", description="The YAML snippet to insert. The snippet will be indented to match the style of its surroundings.", example="labels:\n  label-one: \"value-one\"")
    @Language(value="yml")
    private final String yaml;
    @Option(displayName="Accept theirs", description="When the YAML snippet to insert conflicts with an existing key value pair and an existing key has a different value, prefer the original value.", required=false)
    private final @Nullable Boolean acceptTheirs;
    @Option(displayName="Object identifying property", description="Name of a property which will be used to identify objects (mapping). This serves as the key to match on when merging entries of a sequence.", required=false, example="name")
    @Incubating(since="7.30.0")
    private final @Nullable String objectIdentifyingProperty;
    @Option(displayName="File pattern", description="A glob expression representing a file path to search for (relative to the project root). Blank/null matches all.", required=false, example=".github/workflows/*.yml")
    private final @Nullable String filePattern;
    @Option(displayName="Insert before property", description="Choose an insertion point when multiple mappings exist. Takes the `key` JsonPath into account.", required=false, example="some-key")
    private final @Nullable String insertBefore;
    static final String FOUND_MATCHING_ELEMENT = "FOUND_MATCHING_ELEMENT";
    static final String REMOVE_PREFIX = "REMOVE_PREFIX";

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"yaml", (String)"Must be valid YAML", (Object)this.yaml, y -> new YamlParser().parse(this.yaml).findFirst().map(doc -> !((Yaml.Documents)doc).getDocuments().isEmpty()).orElse(false)));
    }

    public String getDisplayName() {
        return "Merge YAML snippet";
    }

    public String getInstanceNameSuffix() {
        return String.format("at `%s`", this.key);
    }

    public String getDescription() {
        return "Merge a YAML snippet with an existing YAML document.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(this.filePattern), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){
            final JsonPathMatcher matcher;
            final Yaml incoming;
            {
                this.matcher = new JsonPathMatcher(MergeYaml.this.key);
                this.incoming = new YamlParser().parse(MergeYaml.this.yaml).findFirst().map(Yaml.Documents.class::cast).map(docs -> {
                    Yaml.Document doc = docs.getDocuments().get(0);
                    if (doc.getBlock() instanceof Yaml.Mapping) {
                        Yaml.Mapping m = (Yaml.Mapping)doc.getBlock();
                        return m.withEntries(ListUtils.mapFirst(m.getEntries(), entry -> entry.withPrefix(doc.getPrefix())));
                    }
                    if (doc.getBlock() instanceof Yaml.Sequence) {
                        Yaml.Sequence s = (Yaml.Sequence)doc.getBlock();
                        return s.withEntries(ListUtils.mapFirst(s.getEntries(), entry -> entry.withPrefix(doc.getPrefix())));
                    }
                    return doc.getBlock().withPrefix(doc.getPrefix());
                }).orElseThrow(() -> new IllegalArgumentException("Could not parse as YAML"));
            }

            @Override
            public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
                if ("$".equals(MergeYaml.this.key)) {
                    Yaml.Document d = document.withBlock((Yaml.Block)new MergeYamlVisitor((Yaml)document.getBlock(), MergeYaml.this.yaml, Boolean.TRUE.equals(MergeYaml.this.acceptTheirs), MergeYaml.this.objectIdentifyingProperty, MergeYaml.this.insertBefore).visitNonNull(document.getBlock(), ctx, this.getCursor()));
                    return (Boolean)this.getCursor().getMessage(MergeYaml.REMOVE_PREFIX, (Object)false) != false ? d.withEnd(d.getEnd().withPrefix("")) : d;
                }
                Yaml d = super.visitDocument(document, ctx);
                if (d == document && !((Boolean)this.getCursor().getMessage(MergeYaml.FOUND_MATCHING_ELEMENT, (Object)false)).booleanValue()) {
                    String valueKey = this.maybeKeyFromJsonPath(MergeYaml.this.key);
                    if (valueKey == null) {
                        return d;
                    }
                    String snippet = this.incoming instanceof Yaml.Mapping ? valueKey + ":\n" + this.indent(MergeYaml.this.yaml) : valueKey + ":" + (MergeYaml.this.yaml.startsWith(" ") ? MergeYaml.this.yaml : " " + MergeYaml.this.yaml);
                    return ((Yaml.Document)d).withBlock((Yaml.Block)new MergeYamlVisitor((Yaml)((Yaml.Document)d).getBlock(), snippet, Boolean.TRUE.equals(MergeYaml.this.acceptTheirs), MergeYaml.this.objectIdentifyingProperty, MergeYaml.this.insertBefore).visitNonNull(((Yaml.Document)d).getBlock(), ctx, this.getCursor()));
                }
                return d;
            }

            private String indent(String text) {
                int index = text.indexOf(10);
                if (index == -1 || index == text.length() - 1) {
                    return text;
                }
                StringBuilder padding = new StringBuilder();
                for (int i = index + 1; i < text.length() && Character.isWhitespace(text.charAt(i)); ++i) {
                    padding.append(text.charAt(i));
                }
                if (padding.length() == 0) {
                    padding.append("  ");
                }
                return text.replaceAll("(?m)^", padding.toString());
            }

            private @Nullable String maybeKeyFromJsonPath(String jsonPath) {
                if (!jsonPath.startsWith("$.")) {
                    return null;
                }
                if (jsonPath.matches(".*\\[\\s?\\?\\s?\\(\\s?@\\..*\\)\\s?].*")) {
                    return null;
                }
                if (jsonPath.matches(".*\\*.*") || jsonPath.matches(".*\\.\\..*")) {
                    return null;
                }
                return jsonPath.substring(2);
            }

            @Override
            public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
                Yaml m = super.visitMapping(mapping, ctx);
                if (this.matcher.matches(this.getCursor())) {
                    this.getCursor().putMessageOnFirstEnclosing(Yaml.Document.class, MergeYaml.FOUND_MATCHING_ELEMENT, (Object)true);
                    m = (Yaml.Mapping)new MergeYamlVisitor((Yaml)mapping, this.incoming, Boolean.TRUE.equals(MergeYaml.this.acceptTheirs), MergeYaml.this.objectIdentifyingProperty, MergeYaml.this.insertBefore).visitNonNull(mapping, ctx, this.getCursor().getParentOrThrow());
                }
                return m;
            }

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                if (this.matcher.matches(this.getCursor())) {
                    this.getCursor().putMessageOnFirstEnclosing(Yaml.Document.class, MergeYaml.FOUND_MATCHING_ELEMENT, (Object)true);
                    Yaml.Block value = (Yaml.Block)new MergeYamlVisitor((Yaml)entry.getValue(), this.incoming, Boolean.TRUE.equals(MergeYaml.this.acceptTheirs), MergeYaml.this.objectIdentifyingProperty, MergeYaml.this.insertBefore).visitNonNull(entry.getValue(), ctx, this.getCursor());
                    if (value instanceof Yaml.Scalar && value.getPrefix().isEmpty()) {
                        value = value.withPrefix(" ");
                    }
                    return entry.withValue(value);
                }
                return super.visitMappingEntry(entry, ctx);
            }

            @Override
            public Yaml.Sequence visitSequence(Yaml.Sequence sequence, ExecutionContext ctx) {
                if (this.matcher.matches(this.getCursor().getParentOrThrow())) {
                    this.getCursor().putMessageOnFirstEnclosing(Yaml.Document.class, MergeYaml.FOUND_MATCHING_ELEMENT, (Object)true);
                    return sequence.withEntries(ListUtils.map(sequence.getEntries(), entry -> entry.withBlock((Yaml.Block)new MergeYamlVisitor((Yaml)entry.getBlock(), this.incoming, Boolean.TRUE.equals(MergeYaml.this.acceptTheirs), MergeYaml.this.objectIdentifyingProperty, MergeYaml.this.insertBefore).visitNonNull(entry.getBlock(), ctx, new Cursor(this.getCursor(), entry)))));
                }
                return super.visitSequence(sequence, ctx);
            }
        });
    }

    @Generated
    public MergeYaml(String key, @Language(value="yml") String yaml, @Nullable Boolean acceptTheirs, @Nullable String objectIdentifyingProperty, @Nullable String filePattern, @Nullable String insertBefore) {
        this.key = key;
        this.yaml = yaml;
        this.acceptTheirs = acceptTheirs;
        this.objectIdentifyingProperty = objectIdentifyingProperty;
        this.filePattern = filePattern;
        this.insertBefore = insertBefore;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Language(value="yml")
    @Generated
    public String getYaml() {
        return this.yaml;
    }

    @Generated
    public @Nullable Boolean getAcceptTheirs() {
        return this.acceptTheirs;
    }

    @Generated
    public @Nullable String getObjectIdentifyingProperty() {
        return this.objectIdentifyingProperty;
    }

    @Generated
    public @Nullable String getFilePattern() {
        return this.filePattern;
    }

    @Generated
    public @Nullable String getInsertBefore() {
        return this.insertBefore;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MergeYaml(key=" + this.getKey() + ", yaml=" + this.getYaml() + ", acceptTheirs=" + this.getAcceptTheirs() + ", objectIdentifyingProperty=" + this.getObjectIdentifyingProperty() + ", filePattern=" + this.getFilePattern() + ", insertBefore=" + this.getInsertBefore() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MergeYaml)) {
            return false;
        }
        MergeYaml other = (MergeYaml)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$acceptTheirs = this.getAcceptTheirs();
        Boolean other$acceptTheirs = other.getAcceptTheirs();
        if (this$acceptTheirs == null ? other$acceptTheirs != null : !((Object)this$acceptTheirs).equals(other$acceptTheirs)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$yaml = this.getYaml();
        String other$yaml = other.getYaml();
        if (this$yaml == null ? other$yaml != null : !this$yaml.equals(other$yaml)) {
            return false;
        }
        String this$objectIdentifyingProperty = this.getObjectIdentifyingProperty();
        String other$objectIdentifyingProperty = other.getObjectIdentifyingProperty();
        if (this$objectIdentifyingProperty == null ? other$objectIdentifyingProperty != null : !this$objectIdentifyingProperty.equals(other$objectIdentifyingProperty)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        if (this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern)) {
            return false;
        }
        String this$insertBefore = this.getInsertBefore();
        String other$insertBefore = other.getInsertBefore();
        return !(this$insertBefore == null ? other$insertBefore != null : !this$insertBefore.equals(other$insertBefore));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof MergeYaml;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $acceptTheirs = this.getAcceptTheirs();
        result = result * 59 + ($acceptTheirs == null ? 43 : ((Object)$acceptTheirs).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $yaml = this.getYaml();
        result = result * 59 + ($yaml == null ? 43 : $yaml.hashCode());
        String $objectIdentifyingProperty = this.getObjectIdentifyingProperty();
        result = result * 59 + ($objectIdentifyingProperty == null ? 43 : $objectIdentifyingProperty.hashCode());
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        String $insertBefore = this.getInsertBefore();
        result = result * 59 + ($insertBefore == null ? 43 : $insertBefore.hashCode());
        return result;
    }
}

