/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.search;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class FindIndentYamlVisitor<P>
extends YamlVisitor<P> {
    private final SortedMap<Integer, Long> indentFrequencies = new TreeMap<Integer, Long>();

    public @Nullable Yaml preVisit(Yaml tree, P p) {
        String prefix = tree.getPrefix();
        if (StringUtils.hasLineBreak((String)prefix)) {
            int indent = 0;
            for (char c : prefix.toCharArray()) {
                if (c == '\n' || c == '\r') {
                    indent = 0;
                    continue;
                }
                if (!Character.isWhitespace(c)) continue;
                ++indent;
            }
            this.indentFrequencies.merge(indent, 1L, Long::sum);
        }
        return (Yaml)super.preVisit((Tree)tree, p);
    }

    public int getMostCommonIndent() {
        this.indentFrequencies.remove(0);
        if (this.indentFrequencies.getOrDefault(0, 0L) > 1L) {
            return 0;
        }
        return this.calculateMostCommonIndent();
    }

    public long nonZeroIndents() {
        return this.indentFrequencies.tailMap(1).values().stream().mapToLong(f -> f).sum();
    }

    private int calculateMostCommonIndent() {
        TreeMap<Integer, Integer> indentFrequencyAsDivisors = new TreeMap<Integer, Integer>();
        for (Map.Entry<Integer, Long> indentFrequency : this.indentFrequencies.entrySet()) {
            int freq;
            int indent = indentFrequency.getKey();
            switch (indent) {
                case 0: {
                    freq = indentFrequency.getValue().intValue();
                    break;
                }
                case 1: {
                    freq = (int)this.indentFrequencies.tailMap(indent).values().stream().mapToLong(l -> l).sum();
                    break;
                }
                default: {
                    freq = (int)this.indentFrequencies.tailMap(indent).entrySet().stream().filter(inF -> FindIndentYamlVisitor.gcd((Integer)inF.getKey(), indent) != 0).mapToLong(Map.Entry::getValue).sum();
                }
            }
            indentFrequencyAsDivisors.put(indent, freq);
        }
        return indentFrequencyAsDivisors.entrySet().stream().max((e1, e2) -> {
            int valCompare = ((Integer)e1.getValue()).compareTo((Integer)e2.getValue());
            return valCompare != 0 ? valCompare : ((Integer)e1.getKey() == 0 ? -1 : ((Integer)e2.getKey()).compareTo((Integer)e1.getKey()));
        }).map(Map.Entry::getKey).orElse(0);
    }

    private static int gcd(int n1, int n2) {
        return n2 == 0 ? n1 : FindIndentYamlVisitor.gcd(n2, n1 % n2);
    }
}

