/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.format;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class NormalizeLineBreaksVisitor<P>
extends YamlIsoVisitor<P> {
    private final GeneralFormatStyle generalFormatStyle;
    private final @Nullable Tree stopAfter;

    public NormalizeLineBreaksVisitor(GeneralFormatStyle generalFormatStyle, @Nullable Tree stopAfter) {
        this.generalFormatStyle = generalFormatStyle;
        this.stopAfter = stopAfter;
    }

    public @Nullable Yaml postVisit(Yaml tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Yaml.Documents.class, "stop", (Object)true);
        }
        return (Yaml)super.postVisit((Tree)tree, p);
    }

    public @Nullable Yaml visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Yaml)tree;
        }
        Yaml y = (Yaml)super.visit(tree, p);
        if (y != null) {
            String modifiedPrefix = NormalizeLineBreaksVisitor.normalizeNewLines(y.getPrefix(), this.generalFormatStyle.isUseCRLFNewLines());
            if (!y.getPrefix().equals(modifiedPrefix)) {
                y = y.withPrefix(modifiedPrefix);
            }
        }
        return y;
    }

    private static String normalizeNewLines(String text, boolean useCrlf) {
        if (!text.contains("\n")) {
            return text;
        }
        StringBuilder normalized = new StringBuilder();
        char[] charArray = text.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (useCrlf && c == '\n' && (i == 0 || text.charAt(i - 1) != '\r')) {
                normalized.append('\r').append('\n');
                continue;
            }
            if (!useCrlf && c == '\r') continue;
            normalized.append(c);
        }
        return normalized.toString();
    }
}

