/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.nio.file.Path;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.MergeYaml;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class CopyValue
extends ScanningRecipe<Accumulator> {
    @Option(displayName="Old key path", description="A [JsonPath](https://docs.openrewrite.org/reference/jsonpath-and-jsonpathmatcher-reference) expression to locate a YAML key/value pair to copy.", example="$.source.kind")
    private final String oldKeyPath;
    @Option(displayName="Old file path", description="The file path to the YAML file to copy the value from. If `null` then the value will be copied from any yaml file it appears within.", example="src/main/resources/application.yaml", required=false)
    @Nullable
    private final String oldFilePath;
    @Option(displayName="New key path", description="A [JsonPath](https://docs.openrewrite.org/reference/jsonpath-and-jsonpathmatcher-reference) expression defining where the value should be written.", example="$.dest.kind")
    private final String newKey;
    @Option(displayName="New file path", description="The file path to the YAML file to copy the value to. If `null` then the value will be copied only into the same file it was found in.", example="src/main/resources/application.yaml", required=false)
    @Nullable
    private final String newFilePath;

    public String getDisplayName() {
        return "Copy YAML value";
    }

    public String getInstanceNameSuffix() {
        return String.format("%s`%s` to %s`%s`", this.oldFilePath == null ? "" : this.oldFilePath + ":", this.oldKeyPath, this.newFilePath == null ? "" : this.newFilePath + ":", this.newKey);
    }

    public String getDescription() {
        return "Copies a YAML value from one key to another. The existing key/value pair remains unaffected by this change. Attempts to merge the copied value into the new key if it already exists. Attempts to create the new key if it does not exist.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        YamlIsoVisitor<ExecutionContext> visitor = new YamlIsoVisitor<ExecutionContext>(){
            final JsonPathMatcher oldPathMatcher;
            {
                this.oldPathMatcher = new JsonPathMatcher(CopyValue.this.oldKeyPath);
            }

            @Override
            public Yaml.Documents visitDocuments(Yaml.Documents documents, ExecutionContext ctx) {
                if (acc.snippet == null) {
                    return super.visitDocuments(documents, ctx);
                }
                return documents;
            }

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml source = super.visitMappingEntry(entry, ctx);
                if (this.oldPathMatcher.matches(this.getCursor())) {
                    acc.snippet = entry.getValue().print(this.getCursor());
                    acc.path = ((SourceFile)this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath();
                }
                return source;
            }
        };
        if (this.oldFilePath != null) {
            visitor = Preconditions.check((TreeVisitor)new FindSourceFiles(this.oldFilePath).getVisitor(), (TreeVisitor)visitor);
        }
        return visitor;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Accumulator acc) {
        if (acc.snippet == null) {
            return TreeVisitor.noop();
        }
        TreeVisitor visitor = new MergeYaml(this.newKey, acc.snippet, false, null, null).getVisitor();
        visitor = this.newFilePath == null ? Preconditions.check((TreeVisitor)new FindSourceFiles(acc.path.toString()).getVisitor(), visitor) : Preconditions.check((TreeVisitor)new FindSourceFiles(this.newFilePath).getVisitor(), visitor);
        return visitor;
    }

    @Generated
    public CopyValue(String oldKeyPath, @Nullable String oldFilePath, String newKey, @Nullable String newFilePath) {
        this.oldKeyPath = oldKeyPath;
        this.oldFilePath = oldFilePath;
        this.newKey = newKey;
        this.newFilePath = newFilePath;
    }

    @Generated
    public String getOldKeyPath() {
        return this.oldKeyPath;
    }

    @Nullable
    @Generated
    public String getOldFilePath() {
        return this.oldFilePath;
    }

    @Generated
    public String getNewKey() {
        return this.newKey;
    }

    @Nullable
    @Generated
    public String getNewFilePath() {
        return this.newFilePath;
    }

    @NonNull
    @Generated
    public String toString() {
        return "CopyValue(oldKeyPath=" + this.getOldKeyPath() + ", oldFilePath=" + this.getOldFilePath() + ", newKey=" + this.getNewKey() + ", newFilePath=" + this.getNewFilePath() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopyValue)) {
            return false;
        }
        CopyValue other = (CopyValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldKeyPath = this.getOldKeyPath();
        String other$oldKeyPath = other.getOldKeyPath();
        if (this$oldKeyPath == null ? other$oldKeyPath != null : !this$oldKeyPath.equals(other$oldKeyPath)) {
            return false;
        }
        String this$oldFilePath = this.getOldFilePath();
        String other$oldFilePath = other.getOldFilePath();
        if (this$oldFilePath == null ? other$oldFilePath != null : !this$oldFilePath.equals(other$oldFilePath)) {
            return false;
        }
        String this$newKey = this.getNewKey();
        String other$newKey = other.getNewKey();
        if (this$newKey == null ? other$newKey != null : !this$newKey.equals(other$newKey)) {
            return false;
        }
        String this$newFilePath = this.getNewFilePath();
        String other$newFilePath = other.getNewFilePath();
        return !(this$newFilePath == null ? other$newFilePath != null : !this$newFilePath.equals(other$newFilePath));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CopyValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldKeyPath = this.getOldKeyPath();
        result = result * 59 + ($oldKeyPath == null ? 43 : $oldKeyPath.hashCode());
        String $oldFilePath = this.getOldFilePath();
        result = result * 59 + ($oldFilePath == null ? 43 : $oldFilePath.hashCode());
        String $newKey = this.getNewKey();
        result = result * 59 + ($newKey == null ? 43 : $newKey.hashCode());
        String $newFilePath = this.getNewFilePath();
        result = result * 59 + ($newFilePath == null ? 43 : $newFilePath.hashCode());
        return result;
    }

    public static class Accumulator {
        @Nullable
        String snippet;
        Path path;

        @Generated
        public Accumulator() {
        }

        @Nullable
        @Generated
        public String getSnippet() {
            return this.snippet;
        }

        @Generated
        public Path getPath() {
            return this.path;
        }

        @Generated
        public void setSnippet(@Nullable String snippet) {
            this.snippet = snippet;
        }

        @Generated
        public void setPath(Path path) {
            this.path = path;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$snippet = this.getSnippet();
            String other$snippet = other.getSnippet();
            if (this$snippet == null ? other$snippet != null : !this$snippet.equals(other$snippet)) {
                return false;
            }
            Path this$path = this.getPath();
            Path other$path = other.getPath();
            return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Accumulator;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $snippet = this.getSnippet();
            result = result * 59 + ($snippet == null ? 43 : $snippet.hashCode());
            Path $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "CopyValue.Accumulator(snippet=" + this.getSnippet() + ", path=" + this.getPath() + ")";
        }
    }
}

