/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class FindProperty
extends Recipe {
    @Option(displayName="Property key", description="The key to look for. Glob is supported.", example="management.metrics.binders.*.enabled")
    private final String propertyKey;
    @Option(displayName="Use relaxed binding", description="Whether to match the `propertyKey` using [relaxed binding](https://docs.spring.io/spring-boot/docs/2.5.6/reference/html/features.html#features.external-config.typesafe-configuration-properties.relaxed-binding) rules. Defaults to `true`. If you want to use exact matching in your search, set this to `false`.", required=false)
    @Nullable
    private final Boolean relaxedBinding;

    public String getDisplayName() {
        return "Find YAML properties";
    }

    public String getDescription() {
        return "Find YAML properties that match the specified `propertyKey`. Expects dot notation for nested YAML mappings, similar to how Spring Boot interprets `application.yml` files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml e = super.visitMappingEntry(entry, ctx);
                String prop = FindProperty.getProperty(this.getCursor());
                if (!Boolean.FALSE.equals(FindProperty.this.relaxedBinding) ? NameCaseConvention.matchesGlobRelaxedBinding((String)prop, (String)FindProperty.this.propertyKey) : StringUtils.matchesGlob((String)prop, (String)FindProperty.this.propertyKey)) {
                    e = ((Yaml.Mapping.Entry)e).withValue((Yaml.Block)SearchResult.found((Tree)((Yaml.Mapping.Entry)e).getValue()));
                }
                return e;
            }
        };
    }

    public static Set<Yaml.Block> find(Yaml y, final String propertyKey, final @Nullable Boolean relaxedBinding) {
        YamlIsoVisitor<Set<Yaml.Block>> findVisitor = new YamlIsoVisitor<Set<Yaml.Block>>(){

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, Set<Yaml.Block> values) {
                Yaml e = super.visitMappingEntry(entry, values);
                String prop = FindProperty.getProperty(this.getCursor());
                if (!Boolean.FALSE.equals(relaxedBinding) ? NameCaseConvention.matchesGlobRelaxedBinding((String)prop, (String)propertyKey) : StringUtils.matchesGlob((String)prop, (String)propertyKey)) {
                    values.add(entry.getValue());
                }
                return e;
            }
        };
        HashSet<Yaml.Block> values = new HashSet<Yaml.Block>();
        findVisitor.visit(y, values);
        return values;
    }

    public static boolean matches(Cursor cursor, String propertyKey, @Nullable Boolean relaxedBinding) {
        String prop = FindProperty.getProperty(cursor);
        return !Boolean.FALSE.equals(relaxedBinding) ? NameCaseConvention.matchesGlobRelaxedBinding((String)prop, (String)propertyKey) : StringUtils.matchesGlob((String)prop, (String)propertyKey);
    }

    private static String getProperty(Cursor cursor) {
        StringBuilder asProperty = new StringBuilder();
        Iterator path = cursor.getPath();
        int i = 0;
        while (path.hasNext()) {
            Object next = path.next();
            if (!(next instanceof Yaml.Mapping.Entry)) continue;
            Yaml.Mapping.Entry entry = (Yaml.Mapping.Entry)next;
            if (i++ > 0) {
                asProperty.insert(0, '.');
            }
            asProperty.insert(0, entry.getKey().getValue());
        }
        return asProperty.toString();
    }

    public FindProperty(String propertyKey, @Nullable Boolean relaxedBinding) {
        this.propertyKey = propertyKey;
        this.relaxedBinding = relaxedBinding;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Nullable
    public Boolean getRelaxedBinding() {
        return this.relaxedBinding;
    }

    @NonNull
    public String toString() {
        return "FindProperty(propertyKey=" + this.getPropertyKey() + ", relaxedBinding=" + this.getRelaxedBinding() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindProperty)) {
            return false;
        }
        FindProperty other = (FindProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$relaxedBinding = this.getRelaxedBinding();
        Boolean other$relaxedBinding = other.getRelaxedBinding();
        if (this$relaxedBinding == null ? other$relaxedBinding != null : !((Object)this$relaxedBinding).equals(other$relaxedBinding)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        return !(this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $relaxedBinding = this.getRelaxedBinding();
        result = result * 59 + ($relaxedBinding == null ? 43 : ((Object)$relaxedBinding).hashCode());
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        return result;
    }
}

