/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.yaml.MergeYamlVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.search.FindProperty;
import org.openrewrite.yaml.tree.Yaml;

public final class ChangePropertyKey
extends Recipe {
    @Option(displayName="Old property key", description="The property key to rename. Supports glob patterns.", example="management.metrics.binders.*.enabled")
    private final String oldPropertyKey;
    @Option(displayName="New property key", description="The new name for the property key.", example="management.metrics.enable.process.files")
    private final String newPropertyKey;
    @Option(displayName="Use relaxed binding", description="Whether to match the `oldPropertyKey` using [relaxed binding](https://docs.spring.io/spring-boot/docs/2.5.6/reference/html/features.html#features.external-config.typesafe-configuration-properties.relaxed-binding) rules. Defaults to `true`. If you want to use exact matching in your search, set this to `false`.", required=false)
    @Nullable
    private final Boolean relaxedBinding;
    @Option(displayName="Except", description="If any of these property keys exist as direct children of `oldPropertyKey`, then they will not be moved to `newPropertyKey`.", required=false)
    @Nullable
    private final List<String> except;

    public String getDisplayName() {
        return "Change property key";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s` to `%s`", this.oldPropertyKey, this.newPropertyKey);
    }

    public String getDescription() {
        return "Change a YAML property key while leaving the value intact. Expects dot notation for nested YAML mappings, similar to how Spring Boot interprets `application.yml` files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangePropertyKeyVisitor<ExecutionContext>();
    }

    private boolean hasNonExcludedValues(Yaml.Mapping.Entry propertyEntry) {
        if (!(propertyEntry.getValue() instanceof Yaml.Mapping)) {
            return true;
        }
        for (Yaml.Mapping.Entry entry : ((Yaml.Mapping)propertyEntry.getValue()).getEntries()) {
            if (!ChangePropertyKey.noneMatch(entry, this.excludedSubKeys())) continue;
            return true;
        }
        return false;
    }

    private boolean hasExcludedValues(Yaml.Mapping.Entry propertyEntry) {
        if (propertyEntry.getValue() instanceof Yaml.Mapping) {
            for (Yaml.Mapping.Entry entry : ((Yaml.Mapping)propertyEntry.getValue()).getEntries()) {
                if (!this.anyMatch(entry, this.excludedSubKeys())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean anyMatch(Yaml.Mapping.Entry entry, List<String> subKeys) {
        for (String subKey : subKeys) {
            if (!entry.getKey().getValue().equals(subKey) && !entry.getKey().getValue().startsWith(subKey + ".")) continue;
            return true;
        }
        return false;
    }

    private static boolean noneMatch(Yaml.Mapping.Entry entry, List<String> subKeys) {
        for (String subKey : subKeys) {
            if (!entry.getKey().getValue().equals(subKey) && !entry.getKey().getValue().startsWith(subKey + ".")) continue;
            return false;
        }
        return true;
    }

    private boolean noneMatch(String key, String basePattern, List<String> excludedSubKeys) {
        for (String subkey : excludedSubKeys) {
            String subKeyPattern = basePattern + "." + subkey;
            if (!this.matches(key, subKeyPattern) && !this.matches(key, subKeyPattern + ".*")) continue;
            return false;
        }
        return true;
    }

    private boolean matches(String string, String pattern) {
        return !Boolean.FALSE.equals(this.relaxedBinding) ? NameCaseConvention.matchesGlobRelaxedBinding((String)string, (String)pattern) : StringUtils.matchesGlob((String)string, (String)pattern);
    }

    private List<String> excludedSubKeys() {
        return this.except != null ? this.except : Collections.emptyList();
    }

    public ChangePropertyKey(String oldPropertyKey, String newPropertyKey, @Nullable Boolean relaxedBinding, @Nullable List<String> except) {
        this.oldPropertyKey = oldPropertyKey;
        this.newPropertyKey = newPropertyKey;
        this.relaxedBinding = relaxedBinding;
        this.except = except;
    }

    public String getOldPropertyKey() {
        return this.oldPropertyKey;
    }

    public String getNewPropertyKey() {
        return this.newPropertyKey;
    }

    @Nullable
    public Boolean getRelaxedBinding() {
        return this.relaxedBinding;
    }

    @Nullable
    public List<String> getExcept() {
        return this.except;
    }

    @NonNull
    public String toString() {
        return "ChangePropertyKey(oldPropertyKey=" + this.getOldPropertyKey() + ", newPropertyKey=" + this.getNewPropertyKey() + ", relaxedBinding=" + this.getRelaxedBinding() + ", except=" + this.getExcept() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePropertyKey)) {
            return false;
        }
        ChangePropertyKey other = (ChangePropertyKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$relaxedBinding = this.getRelaxedBinding();
        Boolean other$relaxedBinding = other.getRelaxedBinding();
        if (this$relaxedBinding == null ? other$relaxedBinding != null : !((Object)this$relaxedBinding).equals(other$relaxedBinding)) {
            return false;
        }
        String this$oldPropertyKey = this.getOldPropertyKey();
        String other$oldPropertyKey = other.getOldPropertyKey();
        if (this$oldPropertyKey == null ? other$oldPropertyKey != null : !this$oldPropertyKey.equals(other$oldPropertyKey)) {
            return false;
        }
        String this$newPropertyKey = this.getNewPropertyKey();
        String other$newPropertyKey = other.getNewPropertyKey();
        if (this$newPropertyKey == null ? other$newPropertyKey != null : !this$newPropertyKey.equals(other$newPropertyKey)) {
            return false;
        }
        List<String> this$except = this.getExcept();
        List<String> other$except = other.getExcept();
        return !(this$except == null ? other$except != null : !((Object)this$except).equals(other$except));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePropertyKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $relaxedBinding = this.getRelaxedBinding();
        result = result * 59 + ($relaxedBinding == null ? 43 : ((Object)$relaxedBinding).hashCode());
        String $oldPropertyKey = this.getOldPropertyKey();
        result = result * 59 + ($oldPropertyKey == null ? 43 : $oldPropertyKey.hashCode());
        String $newPropertyKey = this.getNewPropertyKey();
        result = result * 59 + ($newPropertyKey == null ? 43 : $newPropertyKey.hashCode());
        List<String> $except = this.getExcept();
        result = result * 59 + ($except == null ? 43 : ((Object)$except).hashCode());
        return result;
    }

    private class ChangePropertyKeyVisitor<P>
    extends YamlIsoVisitor<P> {
        private ChangePropertyKeyVisitor() {
        }

        @Override
        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, P p) {
            Yaml e;
            block6: {
                String propertyToTest;
                String prop;
                Deque propertyEntries;
                block7: {
                    e = super.visitMappingEntry(entry, (Object)p);
                    if (this.getCursor().firstEnclosing(Yaml.Sequence.class) != null) {
                        return e;
                    }
                    propertyEntries = this.getCursor().getPathAsStream().filter(Yaml.Mapping.Entry.class::isInstance).map(Yaml.Mapping.Entry.class::cast).collect(Collectors.toCollection(ArrayDeque::new));
                    prop = StreamSupport.stream(Spliterators.spliteratorUnknownSize(propertyEntries.descendingIterator(), 0), false).map(e2 -> e2.getKey().getValue()).collect(Collectors.joining("."));
                    if (ChangePropertyKey.this.newPropertyKey.startsWith(ChangePropertyKey.this.oldPropertyKey) && (ChangePropertyKey.this.matches(prop, ChangePropertyKey.this.newPropertyKey) || ChangePropertyKey.this.matches(prop, ChangePropertyKey.this.newPropertyKey + ".*") || this.childMatchesNewPropertyKey(entry, prop))) {
                        return e;
                    }
                    propertyToTest = ChangePropertyKey.this.newPropertyKey;
                    if (!ChangePropertyKey.this.matches(prop, ChangePropertyKey.this.oldPropertyKey)) break block7;
                    Iterator propertyEntriesLeftToRight = propertyEntries.descendingIterator();
                    while (propertyEntriesLeftToRight.hasNext()) {
                        Yaml.Mapping.Entry propertyEntry = (Yaml.Mapping.Entry)propertyEntriesLeftToRight.next();
                        String value = propertyEntry.getKey().getValue() + ".";
                        if ((!propertyToTest.startsWith(value) || propertyToTest.startsWith(value) && !propertyEntriesLeftToRight.hasNext()) && ChangePropertyKey.this.hasNonExcludedValues(propertyEntry)) {
                            this.doAfterVisit(new InsertSubpropertyVisitor(propertyEntry, propertyToTest, entry));
                            break block6;
                        }
                        propertyToTest = propertyToTest.substring(value.length());
                    }
                    break block6;
                }
                String parentProp = prop.substring(0, prop.length() - ((Yaml.Mapping.Entry)e).getKey().getValue().length()).replaceAll(".$", "");
                if (!ChangePropertyKey.this.matches(prop, ChangePropertyKey.this.oldPropertyKey + ".*") || ChangePropertyKey.this.matches(parentProp, ChangePropertyKey.this.oldPropertyKey + ".*") || ChangePropertyKey.this.matches(parentProp, ChangePropertyKey.this.oldPropertyKey) || !ChangePropertyKey.this.noneMatch(prop, ChangePropertyKey.this.oldPropertyKey, ChangePropertyKey.this.excludedSubKeys())) break block6;
                Iterator propertyEntriesLeftToRight = propertyEntries.descendingIterator();
                while (propertyEntriesLeftToRight.hasNext()) {
                    Yaml.Mapping.Entry propertyEntry = (Yaml.Mapping.Entry)propertyEntriesLeftToRight.next();
                    String value = propertyEntry.getKey().getValue() + ".";
                    if (!propertyToTest.startsWith(value) || propertyToTest.startsWith(value) && !propertyEntriesLeftToRight.hasNext()) {
                        this.doAfterVisit(new InsertSubpropertyVisitor(propertyEntry, propertyToTest + prop.substring(ChangePropertyKey.this.oldPropertyKey.length()), entry));
                        break;
                    }
                    propertyToTest = propertyToTest.substring(value.length());
                }
            }
            return e;
        }

        private boolean childMatchesNewPropertyKey(Yaml.Mapping.Entry entry, String cursorPropertyKey) {
            String rescopedNewPropertyKey = ChangePropertyKey.this.newPropertyKey.replaceFirst(Pattern.quote(cursorPropertyKey), entry.getKey().getValue());
            return !FindProperty.find(entry, rescopedNewPropertyKey, ChangePropertyKey.this.relaxedBinding).isEmpty();
        }
    }

    private static class DeletePropertyVisitor<P>
    extends YamlIsoVisitor<P> {
        private final Yaml.Mapping.Entry scope;

        private DeletePropertyVisitor(Yaml.Mapping.Entry scope) {
            this.scope = scope;
        }

        @Override
        public Yaml.Mapping visitMapping(Yaml.Mapping mapping, P p) {
            Yaml m = super.visitMapping(mapping, (Object)p);
            boolean changed = false;
            ArrayList<Yaml.Mapping.Entry> entries = new ArrayList();
            for (Yaml.Mapping.Entry entry : ((Yaml.Mapping)m).getEntries()) {
                if (entry == this.scope || entry.getValue() instanceof Yaml.Mapping && ((Yaml.Mapping)entry.getValue()).getEntries().isEmpty()) {
                    changed = true;
                    continue;
                }
                entries.add(entry);
            }
            if (entries.size() == 1) {
                entries = ListUtils.map(entries, e -> e.withPrefix(""));
            }
            if (changed) {
                Yaml.Document document;
                m = ((Yaml.Mapping)m).withEntries(entries);
                if (this.getCursor().getParentOrThrow().getValue() instanceof Yaml.Document && !(document = (Yaml.Document)this.getCursor().getParentOrThrow().getValue()).isExplicit()) {
                    m = ((Yaml.Mapping)m).withEntries(((Yaml.Mapping)m).getEntries());
                }
            }
            return m;
        }
    }

    private class InsertSubpropertyVisitor<P>
    extends YamlIsoVisitor<P> {
        private final Yaml.Mapping.Entry scope;
        private final String subproperty;
        private final Yaml.Mapping.Entry entryToReplace;

        private InsertSubpropertyVisitor(Yaml.Mapping.Entry scope, String subproperty, Yaml.Mapping.Entry entryToReplace) {
            this.scope = scope;
            this.subproperty = subproperty;
            this.entryToReplace = entryToReplace;
        }

        @Override
        public Yaml.Mapping visitMapping(Yaml.Mapping mapping, P p) {
            Yaml m = super.visitMapping(mapping, (Object)p);
            if (((Yaml.Mapping)m).getEntries().contains(this.scope)) {
                String newEntryPrefix = this.scope.getPrefix();
                Yaml.Mapping.Entry newEntry = new Yaml.Mapping.Entry(Tree.randomId(), newEntryPrefix, Markers.EMPTY, new Yaml.Scalar(Tree.randomId(), "", Markers.EMPTY, Yaml.Scalar.Style.PLAIN, null, this.subproperty), this.scope.getBeforeMappingValueIndicator(), this.removeExclusions(this.entryToReplace.getValue().copyPaste()));
                if (ChangePropertyKey.this.hasExcludedValues(this.entryToReplace)) {
                    m = ((Yaml.Mapping)m).withEntries(ListUtils.concat(((Yaml.Mapping)m).getEntries(), (Object)newEntry));
                } else if (((Yaml.Mapping)m).getEntries().contains(this.entryToReplace)) {
                    m = ((Yaml.Mapping)m).withEntries(ListUtils.map(((Yaml.Mapping)m).getEntries(), e -> {
                        if (e.equals(this.entryToReplace)) {
                            return newEntry.withPrefix(e.getPrefix());
                        }
                        return e;
                    }));
                } else {
                    m = (Yaml.Mapping)new DeletePropertyVisitor(this.entryToReplace).visitNonNull(m, p);
                    Yaml.Mapping newMapping = ((Yaml.Mapping)m).withEntries(Collections.singletonList(newEntry));
                    Yaml.Mapping mergedMapping = (Yaml.Mapping)new MergeYamlVisitor<P>(m, newMapping, true, null, false).visitMapping((Yaml.Mapping)m, p);
                    m = this.maybeAutoFormat(m, mergedMapping, p, this.getCursor().getParentOrThrow());
                }
            }
            return m;
        }

        @Override
        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry originalEntry, P p) {
            Yaml e = super.visitMappingEntry(originalEntry, (Object)p);
            if (e == this.entryToReplace && ChangePropertyKey.this.hasNonExcludedValues(this.entryToReplace) && ((Yaml.Mapping.Entry)e).getValue() instanceof Yaml.Mapping) {
                return ((Yaml.Mapping.Entry)e).withValue(this.onlyExclusions((Yaml.Mapping)((Yaml.Mapping.Entry)e).getValue()));
            }
            return e;
        }

        private Yaml.Mapping onlyExclusions(Yaml.Mapping mapping) {
            ArrayList<Yaml.Mapping.Entry> list = new ArrayList<Yaml.Mapping.Entry>();
            for (Yaml.Mapping.Entry entry : mapping.getEntries()) {
                if (ChangePropertyKey.noneMatch(entry, ChangePropertyKey.this.excludedSubKeys())) continue;
                list.add(entry);
            }
            return mapping.withEntries(list);
        }

        private Yaml.Block removeExclusions(Yaml.Block block) {
            if (!(block instanceof Yaml.Mapping)) {
                return block;
            }
            Yaml.Mapping mapping = (Yaml.Mapping)block;
            ArrayList<Yaml.Mapping.Entry> list = new ArrayList<Yaml.Mapping.Entry>();
            for (Yaml.Mapping.Entry entry : mapping.getEntries()) {
                if (!ChangePropertyKey.noneMatch(entry, ChangePropertyKey.this.excludedSubKeys())) continue;
                list.add(entry);
            }
            return mapping.withEntries(list);
        }
    }
}

