/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class ChangeValue
extends Recipe {
    @Option(displayName="Key path", description="A [JsonPath](https://github.com/json-path/JsonPath) expression to locate a YAML entry.", example="$.subjects.kind")
    private final String oldKeyPath;
    @Option(displayName="New value", description="The new value to set for the key identified by the `oldKeyPath`.", example="Deployment")
    private final String value;

    public String getDisplayName() {
        return "Change value";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s` to `%s`", this.oldKeyPath, this.value);
    }

    public String getDescription() {
        return "Change a YAML mapping entry value while leaving the key intact.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher matcher = new JsonPathMatcher(this.oldKeyPath);
        return new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml e = super.visitMappingEntry(entry, ctx);
                if (!(!matcher.matches(this.getCursor()) || ((Yaml.Mapping.Entry)e).getValue() instanceof Yaml.Scalar && ((Yaml.Scalar)((Yaml.Mapping.Entry)e).getValue()).getValue().equals(ChangeValue.this.value))) {
                    Yaml.Anchor anchor = ((Yaml.Mapping.Entry)e).getValue() instanceof Yaml.Scalar ? ((Yaml.Scalar)((Yaml.Mapping.Entry)e).getValue()).getAnchor() : null;
                    String prefix = ((Yaml.Mapping.Entry)e).getValue() instanceof Yaml.Sequence ? ((Yaml.Sequence)((Yaml.Mapping.Entry)e).getValue()).getOpeningBracketPrefix() : ((Yaml.Mapping.Entry)e).getValue().getPrefix();
                    e = ((Yaml.Mapping.Entry)e).withValue(new Yaml.Scalar(Tree.randomId(), prefix, Markers.EMPTY, Yaml.Scalar.Style.PLAIN, anchor, ChangeValue.this.value));
                }
                return e;
            }

            @Override
            public Yaml.Scalar visitScalar(Yaml.Scalar scalar, ExecutionContext ctx) {
                Yaml s = super.visitScalar(scalar, ctx);
                if (matcher.matches(this.getCursor())) {
                    s = ((Yaml.Scalar)s).withValue(ChangeValue.this.value);
                }
                return s;
            }
        };
    }

    public ChangeValue(String oldKeyPath, String value) {
        this.oldKeyPath = oldKeyPath;
        this.value = value;
    }

    public String getOldKeyPath() {
        return this.oldKeyPath;
    }

    public String getValue() {
        return this.value;
    }

    @NonNull
    public String toString() {
        return "ChangeValue(oldKeyPath=" + this.getOldKeyPath() + ", value=" + this.getValue() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeValue)) {
            return false;
        }
        ChangeValue other = (ChangeValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldKeyPath = this.getOldKeyPath();
        String other$oldKeyPath = other.getOldKeyPath();
        if (this$oldKeyPath == null ? other$oldKeyPath != null : !this$oldKeyPath.equals(other$oldKeyPath)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldKeyPath = this.getOldKeyPath();
        result = result * 59 + ($oldKeyPath == null ? 43 : $oldKeyPath.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

