/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.Arrays;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class ShiftFormatLeftVisitor<P>
extends YamlIsoVisitor<P> {
    private final Yaml scope;
    private final int shift;

    public ShiftFormatLeftVisitor(Yaml scope, int shift) {
        this.scope = scope;
        this.shift = shift;
    }

    @Override
    public Yaml.Sequence.Entry visitSequenceEntry(Yaml.Sequence.Entry entry, P p) {
        Yaml e = super.visitSequenceEntry(entry, (Object)p);
        if (this.getCursor().isScopeInPath((Tree)this.scope) && ((Yaml.Sequence.Entry)e).isDash()) {
            e = ((Yaml.Sequence.Entry)e).withPrefix(this.shiftPrefix(((Yaml.Sequence.Entry)e).getPrefix()));
        }
        return e;
    }

    @Override
    public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, P p) {
        Yaml e = super.visitMappingEntry(entry, (Object)p);
        if (this.getCursor().isScopeInPath((Tree)this.scope) && ((Yaml.Mapping.Entry)e).getPrefix().contains("\n")) {
            e = ((Yaml.Mapping.Entry)e).withPrefix(this.shiftPrefix(((Yaml.Mapping.Entry)e).getPrefix()));
        }
        return e;
    }

    private String shiftPrefix(String prefix) {
        return String.join((CharSequence)"\n", ListUtils.map(Arrays.asList(prefix.split("\\n")), (index, s) -> {
            if (index == 0 && !s.trim().isEmpty()) {
                return s;
            }
            if (StringUtils.indexOfNonWhitespace((String)s) >= this.shift || StringUtils.indexOfNonWhitespace((String)s) == -1 && s.length() >= this.shift) {
                return s.substring(this.shift);
            }
            return s;
        }));
    }
}

