/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class MergeYamlVisitor
extends YamlVisitor<ExecutionContext> {
    final Yaml scope;
    final Yaml incoming;

    @Override
    public Yaml visitScalar(Yaml.Scalar existingScalar, ExecutionContext executionContext) {
        if (!this.scope.isScope(existingScalar)) {
            return super.visitScalar(existingScalar, executionContext);
        }
        return MergeYamlVisitor.mergeScalar(existingScalar, (Yaml.Scalar)this.incoming);
    }

    @Override
    public Yaml visitSequence(Yaml.Sequence existingSeq, ExecutionContext ctx) {
        if (!this.scope.isScope(existingSeq)) {
            return super.visitSequence(existingSeq, ctx);
        }
        return MergeYamlVisitor.mergeSequence(existingSeq, (Yaml.Sequence)this.incoming, ctx, this.getCursor());
    }

    @Override
    public Yaml visitMapping(Yaml.Mapping existingMapping, ExecutionContext ctx) {
        if (!this.scope.isScope(existingMapping)) {
            return super.visitMapping(existingMapping, ctx);
        }
        return MergeYamlVisitor.mergeMapping(existingMapping, (Yaml.Mapping)this.incoming, ctx, this.getCursor());
    }

    private static boolean keyMatches(Yaml.Mapping.Entry e1, Yaml.Mapping.Entry e2) {
        return e1.getKey().getValue().equals(e2.getKey().getValue());
    }

    private static Yaml.Mapping mergeMapping(Yaml.Mapping m1, Yaml.Mapping m2, ExecutionContext ctx, Cursor cursor) {
        List mutatedEntries = ListUtils.map(m1.getEntries(), existingEntry -> m2.getEntries().stream().filter(incomingEntry -> MergeYamlVisitor.keyMatches(existingEntry, incomingEntry)).findFirst().map(incomingEntry -> existingEntry.withValue((Yaml.Block)new MergeYamlVisitor(existingEntry.getValue(), incomingEntry.getValue()).visit(existingEntry.getValue(), ctx, cursor))).orElse((Yaml.Mapping.Entry)existingEntry));
        return m1.withEntries(mutatedEntries);
    }

    private static Yaml.Sequence mergeSequence(Yaml.Sequence existingSeq, Yaml.Sequence incomingSeq, ExecutionContext ctx, Cursor cursor) {
        AtomicInteger idx = new AtomicInteger(0);
        List<Yaml.Sequence.Entry> incomingEntries = incomingSeq.getEntries();
        List entries = ListUtils.map(existingSeq.getEntries(), existingSeqEntry -> {
            Yaml.Sequence.Entry incomingEntry = (Yaml.Sequence.Entry)incomingEntries.get(idx.getAndIncrement());
            Yaml.Block b = (Yaml.Block)new MergeYamlVisitor(existingSeqEntry.getBlock(), incomingEntry.getBlock()).visit(existingSeqEntry.getBlock(), ctx, cursor);
            return existingSeqEntry.withBlock(Objects.requireNonNull(b));
        });
        return existingSeq.withEntries(entries);
    }

    private static Yaml.Scalar mergeScalar(Yaml.Scalar y1, Yaml.Scalar y2) {
        String s2;
        String s1 = y1.getValue();
        return !s1.equals(s2 = y2.getValue()) ? y1.withValue(s2) : y1;
    }

    public MergeYamlVisitor(Yaml scope, Yaml incoming) {
        this.scope = scope;
        this.incoming = incoming;
    }
}

