/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.List;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.MergeYamlVisitor;
import org.openrewrite.yaml.XPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.format.AutoFormatVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class MergeYaml
extends Recipe {
    @Option(displayName="Key path", description="XPath expression used to find matching keys.", example="/metadata")
    private final String key;
    @Option(displayName="YAML snippet", description="The YAML snippet to insert. The snippet will be indented to match the style of its surroundings.", example="labels: \n\tlabel-one: \"value-one\"")
    @Language(value="yml")
    private final String yaml;

    public Validated validate() {
        return super.validate().and(Validated.test((String)"yaml", (String)"Must be valid YAML", (Object)this.yaml, y -> {
            List<Yaml.Documents> docs = new YamlParser().parse(this.yaml);
            if (docs.size() == 0) {
                return false;
            }
            Yaml.Documents doc = docs.get(0);
            if (doc.getDocuments().size() == 0) {
                return false;
            }
            Yaml.Block block = doc.getDocuments().get(0).getBlock();
            return block instanceof Yaml.Mapping;
        }));
    }

    public String getDisplayName() {
        return "Merge YAML snippet";
    }

    public String getDescription() {
        return "Merge a YAML snippet with an existing YAML document.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final XPathMatcher matcher = new XPathMatcher(this.key);
        final Yaml.Mapping incoming = (Yaml.Mapping)new YamlParser().parse(this.yaml).get(0).getDocuments().get(0).getBlock();
        return new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml e = super.visitMappingEntry(entry, ctx);
                if (matcher.matches(this.getCursor())) {
                    this.doAfterVisit(new MergeYamlVisitor((Yaml)this.getCursor().getParentOrThrow().getValue(), incoming));
                    this.doAfterVisit(new AutoFormatVisitor(e));
                }
                return e;
            }
        };
    }

    public MergeYaml(String key, String yaml) {
        this.key = key;
        this.yaml = yaml;
    }

    public String getKey() {
        return this.key;
    }

    public String getYaml() {
        return this.yaml;
    }

    @NonNull
    public String toString() {
        return "MergeYaml(key=" + this.getKey() + ", yaml=" + this.getYaml() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MergeYaml)) {
            return false;
        }
        MergeYaml other = (MergeYaml)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$yaml = this.getYaml();
        String other$yaml = other.getYaml();
        return !(this$yaml == null ? other$yaml != null : !this$yaml.equals(other$yaml));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MergeYaml;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $yaml = this.getYaml();
        result = result * 59 + ($yaml == null ? 43 : $yaml.hashCode());
        return result;
    }
}

