/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.Objects;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.style.Autodetect;
import org.openrewrite.yaml.style.YamlDefaultStyles;
import org.openrewrite.yaml.tree.Yaml;

@Incubating(since="7.2.0")
public class InsertYamlVisitor<P>
extends YamlIsoVisitor<P> {
    private final Yaml scope;
    private final String yamlString;
    @Nullable
    private Yaml.Block yaml;

    public InsertYamlVisitor(Yaml scope, String yaml) {
        this.scope = scope;
        this.yamlString = yaml;
    }

    @Override
    public Yaml.Documents visitDocuments(Yaml.Documents documents, P p) {
        if (this.yaml == null) {
            Yaml.Documents docs = (Yaml.Documents)new YamlParser().parse((ExecutionContext)(p instanceof ExecutionContext ? (ExecutionContext)p : new InMemoryExecutionContext()), new String[]{this.yamlString}).get(0);
            StringBuilder leadingIndentBuilder = new StringBuilder();
            if (!(this.scope instanceof Yaml.Document)) {
                for (int i = 0; i < this.findIndent(this.scope.getPrefix()) + Autodetect.tabsAndIndents(documents, YamlDefaultStyles.indents()).getIndentSize(); ++i) {
                    leadingIndentBuilder.append(' ');
                }
            }
            docs = (Yaml.Documents)new YamlIsoVisitor<Integer>(){
                boolean firstBlock = true;

                public Yaml preVisit(Yaml tree, Integer integer) {
                    if ((tree instanceof Yaml.Mapping.Entry || tree instanceof Yaml.Sequence.Entry) && this.firstBlock) {
                        tree = tree.withPrefix("\n");
                        this.firstBlock = false;
                    }
                    return tree;
                }
            }.visit(docs, 0);
            assert (docs != null);
            docs = this.shiftRight(docs, leadingIndentBuilder.toString());
            this.yaml = docs.getDocuments().get(0).getBlock();
        }
        return super.visitDocuments(documents, (Object)p);
    }

    @Override
    public Yaml.Document visitDocument(Yaml.Document document, P p) {
        Yaml.Document d = document;
        if (this.scope.isScope(d) && d.getBlock() instanceof Yaml.Mapping) {
            d = d.withBlock(this.addEntries((Yaml.Mapping)d.getBlock(), this.yaml));
            return d;
        }
        return super.visitDocument(d, (Object)p);
    }

    @Override
    public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, P p) {
        Yaml e = super.visitMappingEntry(entry, (Object)p);
        if (this.scope.isScope(entry)) {
            Yaml.Block value = ((Yaml.Mapping.Entry)e).getValue();
            assert (this.yaml != null);
            e = ((Yaml.Mapping.Entry)e).withValue(this.insertIntoBlock(value, this.yaml));
        }
        return e;
    }

    private Yaml.Block insertIntoBlock(Yaml.Block block, Yaml.Block insert) {
        if (block instanceof Yaml.Scalar && ((Yaml.Scalar)block).getValue().isEmpty()) {
            return insert;
        }
        if (block instanceof Yaml.Mapping) {
            return this.addEntries((Yaml.Mapping)block, insert);
        }
        if (block instanceof Yaml.Sequence) {
            Yaml.Sequence seq = (Yaml.Sequence)block;
            return seq.withEntries(ListUtils.map(seq.getEntries(), entry -> {
                if (entry.getBlock() instanceof Yaml.Mapping) {
                    Yaml.Mapping mapping = (Yaml.Mapping)entry.getBlock();
                    Yaml.Block shiftedInsert = this.shiftRight(insert, mapping.getEntries().iterator().next().getPrefix() + " ");
                    return entry.withBlock(this.insertIntoBlock(entry.getBlock(), shiftedInsert));
                }
                return entry;
            }));
        }
        return block;
    }

    private Yaml.Mapping addEntries(Yaml.Mapping map, @Nullable Yaml.Block insert) {
        assert (insert instanceof Yaml.Mapping);
        return map.withEntries(ListUtils.concatAll(map.getEntries(), ((Yaml.Mapping)insert).getEntries().stream().filter(newEntry -> map.getEntries().stream().noneMatch(existingEntry -> existingEntry.getKey().getValue().equals(newEntry.getKey().getValue()))).collect(Collectors.toList())));
    }

    private int findIndent(String prefix) {
        int size = 0;
        for (char c : prefix.toCharArray()) {
            ++size;
            if (c != '\n' && c != '\r') continue;
            size = 0;
        }
        return size;
    }

    private <Y extends Yaml> Y shiftRight(Y y, final String shift) {
        return (Y)Objects.requireNonNull((Yaml)new YamlIsoVisitor<Integer>(){

            public Yaml preVisit(Yaml tree, Integer integer) {
                if (tree.getPrefix().contains("\n")) {
                    tree = tree.withPrefix(tree.getPrefix() + shift);
                }
                return tree;
            }
        }.visit(y, 0));
    }
}

