/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.yaml.FormatPreservingReader;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.Scanner;
import org.yaml.snakeyaml.scanner.ScannerImpl;

public class YamlParser
implements Parser<Yaml.Documents> {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile(":\\s*(@[^\n\r@]+@)");

    public List<Yaml.Documents> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public List<Yaml.Documents> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        return this.acceptedInputs(sourceFiles).stream().map(sourceFile -> {
            Yaml.Documents documents;
            block8: {
                Timer.Builder timer = Timer.builder((String)"rewrite.parse").description("The time spent parsing a YAML file").tag("file.type", "YAML");
                Timer.Sample sample = Timer.start();
                InputStream is = sourceFile.getSource();
                try {
                    Yaml.Documents yaml = this.parseFromInput(sourceFile.getRelativePath(relativeTo), is);
                    sample.stop(MetricsHelper.successTags((Timer.Builder)timer).register((MeterRegistry)Metrics.globalRegistry));
                    documents = yaml;
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        sample.stop(MetricsHelper.errorTags((Timer.Builder)timer, (Throwable)t).register((MeterRegistry)Metrics.globalRegistry));
                        ctx.getOnError().accept(t);
                        return null;
                    }
                }
                is.close();
            }
            return documents;
        }).filter(Objects::nonNull).map(this::unwrapPrefixedMappings).map(docs -> {
            if (docs.getDocuments().isEmpty()) {
                return docs.withDocuments(Collections.singletonList(new Yaml.Document(Tree.randomId(), "", Markers.EMPTY, false, new Yaml.Mapping(Tree.randomId(), Markers.EMPTY, Collections.emptyList()), null)));
            }
            return docs;
        }).collect(Collectors.toList());
    }

    private Yaml.Documents parseFromInput(Path sourceFile, InputStream source) {
        Yaml.Documents documents;
        String yamlSource = StringUtils.readFully((InputStream)source);
        HashMap<String, String> variableByUuid = new HashMap<String, String>();
        StringBuilder yamlSourceWithVariablePlaceholders = new StringBuilder();
        Matcher variableMatcher = VARIABLE_PATTERN.matcher(yamlSource);
        int pos = 0;
        while (pos < yamlSource.length() && variableMatcher.find(pos)) {
            yamlSourceWithVariablePlaceholders.append(yamlSource, pos, variableMatcher.start(1));
            String uuid = UUID.randomUUID().toString();
            variableByUuid.put(uuid, variableMatcher.group(1));
            yamlSourceWithVariablePlaceholders.append(uuid);
            pos = variableMatcher.end(1);
        }
        if (pos < yamlSource.length() - 1) {
            yamlSourceWithVariablePlaceholders.append(yamlSource, pos, yamlSource.length());
        }
        FormatPreservingReader reader = new FormatPreservingReader(new InputStreamReader(new ByteArrayInputStream(yamlSourceWithVariablePlaceholders.toString().getBytes(StandardCharsets.UTF_8))));
        try {
            StreamReader streamReader = new StreamReader((Reader)reader);
            ScannerImpl scanner = new ScannerImpl(streamReader);
            ParserImpl parser = new ParserImpl((Scanner)scanner);
            int lastEnd = 0;
            ArrayList<Yaml.Document> documents2 = new ArrayList<Yaml.Document>();
            Yaml.Document document = null;
            Stack<BlockBuilder> blockStack = new Stack<BlockBuilder>();
            Event event = parser.getEvent();
            while (event != null) {
                String fmt = reader.prefix(lastEnd, event);
                switch (event.getEventId()) {
                    case DocumentEnd: {
                        assert (document != null);
                        documents2.add(document.withEnd(new Yaml.Document.End(Tree.randomId(), fmt, Markers.EMPTY, ((DocumentEndEvent)event).getExplicit())));
                        lastEnd = event.getEndMark().getIndex();
                        break;
                    }
                    case DocumentStart: {
                        document = new Yaml.Document(Tree.randomId(), fmt, Markers.EMPTY, event.getEndMark().getIndex() - event.getStartMark().getIndex() > 0, new Yaml.Mapping(Tree.randomId(), Markers.EMPTY, Collections.emptyList()), null);
                        lastEnd = event.getEndMark().getIndex();
                        break;
                    }
                    case MappingStart: {
                        blockStack.push(new MappingBuilder(fmt));
                        break;
                    }
                    case Scalar: {
                        Yaml.Scalar.Style style;
                        ScalarEvent scalar = (ScalarEvent)event;
                        String scalarValue = scalar.getValue();
                        if (variableByUuid.containsKey(scalarValue)) {
                            scalarValue = (String)variableByUuid.get(scalarValue);
                        }
                        switch (scalar.getScalarStyle()) {
                            case DOUBLE_QUOTED: {
                                style = Yaml.Scalar.Style.DOUBLE_QUOTED;
                                break;
                            }
                            case SINGLE_QUOTED: {
                                style = Yaml.Scalar.Style.SINGLE_QUOTED;
                                break;
                            }
                            case LITERAL: {
                                style = Yaml.Scalar.Style.LITERAL;
                                scalarValue = reader.readStringFromBuffer(event.getStartMark().getIndex() + 1, event.getEndMark().getIndex() - 1);
                                break;
                            }
                            case FOLDED: {
                                style = Yaml.Scalar.Style.FOLDED;
                                scalarValue = reader.readStringFromBuffer(event.getStartMark().getIndex() + 1, event.getEndMark().getIndex() - 1);
                                break;
                            }
                            default: {
                                style = Yaml.Scalar.Style.PLAIN;
                            }
                        }
                        BlockBuilder builder = (BlockBuilder)blockStack.peek();
                        if (builder instanceof SequenceBuilder) {
                            SequenceBuilder sequenceBuilder = (SequenceBuilder)builder;
                            String betweenEvents = reader.readStringFromBuffer(event.getEndMark().getIndex(), parser.peekEvent().getStartMark().getIndex() - 1);
                            int commaIndex = YamlParser.commentAwareIndexOf(',', betweenEvents);
                            String commaPrefix = null;
                            if (commaIndex != -1) {
                                commaPrefix = betweenEvents.substring(0, commaIndex);
                            }
                            lastEnd = event.getEndMark().getIndex() + commaIndex + 1;
                            sequenceBuilder.push(new Yaml.Scalar(Tree.randomId(), fmt, Markers.EMPTY, style, scalarValue), commaPrefix);
                            break;
                        }
                        builder.push(new Yaml.Scalar(Tree.randomId(), fmt, Markers.EMPTY, style, scalarValue));
                        lastEnd = event.getEndMark().getIndex();
                        break;
                    }
                    case SequenceEnd: 
                    case MappingEnd: {
                        Yaml.Sequence seq;
                        Yaml.Block mappingOrSequence = ((BlockBuilder)blockStack.pop()).build();
                        if (mappingOrSequence instanceof Yaml.Sequence && (seq = (Yaml.Sequence)mappingOrSequence).getOpeningBracketPrefix() != null) {
                            String s = reader.readStringFromBuffer(lastEnd, event.getStartMark().getIndex());
                            int closingBracketIndex = YamlParser.commentAwareIndexOf(']', s);
                            lastEnd = lastEnd + closingBracketIndex + 1;
                            mappingOrSequence = seq.withClosingBracketPrefix(s.substring(0, closingBracketIndex));
                        }
                        if (blockStack.isEmpty()) {
                            assert (document != null);
                            document = document.withBlock(mappingOrSequence);
                            break;
                        }
                        ((BlockBuilder)blockStack.peek()).push(mappingOrSequence);
                        break;
                    }
                    case SequenceStart: {
                        String fullPrefix = reader.readStringFromBuffer(lastEnd, event.getEndMark().getIndex() - 1);
                        String startBracketPrefix = null;
                        int openingBracketIndex = YamlParser.commentAwareIndexOf('[', fullPrefix);
                        if (openingBracketIndex != -1) {
                            int startIndex = YamlParser.commentAwareIndexOf(':', fullPrefix) + 1;
                            startBracketPrefix = fullPrefix.substring(startIndex, openingBracketIndex);
                            lastEnd = event.getEndMark().getIndex();
                        }
                        blockStack.push(new SequenceBuilder(fmt, startBracketPrefix));
                        break;
                    }
                }
                event = parser.getEvent();
            }
            documents = new Yaml.Documents(Tree.randomId(), Markers.EMPTY, sourceFile, documents2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        reader.close();
        return documents;
    }

    private static int commentAwareIndexOf(char target, String s) {
        boolean inComment = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (inComment) {
                if (c != '\n') continue;
                inComment = false;
                continue;
            }
            if (c == target) {
                return i;
            }
            if (c != '#') continue;
            inComment = true;
        }
        return -1;
    }

    public boolean accept(Path path) {
        String fileName = path.toString();
        return fileName.endsWith(".yml") || fileName.endsWith(".yaml");
    }

    private Yaml.Documents unwrapPrefixedMappings(Yaml.Documents y) {
        return (Yaml.Documents)new YamlIsoVisitor<Integer>(){

            @Override
            public Yaml.Sequence visitSequence(Yaml.Sequence sequence, Integer p) {
                if (sequence instanceof SequenceWithPrefix) {
                    SequenceWithPrefix sequenceWithPrefix = (SequenceWithPrefix)sequence;
                    return super.visitSequence(new Yaml.Sequence(sequenceWithPrefix.getId(), sequenceWithPrefix.getMarkers(), sequenceWithPrefix.getOpeningBracketPrefix(), ListUtils.mapFirst(sequenceWithPrefix.getEntries(), e -> e.withPrefix(sequenceWithPrefix.getPrefix())), sequenceWithPrefix.getClosingBracketPrefix()), p);
                }
                return super.visitSequence(sequence, p);
            }

            @Override
            public Yaml.Mapping visitMapping(Yaml.Mapping mapping, Integer p) {
                if (mapping instanceof MappingWithPrefix) {
                    MappingWithPrefix mappingWithPrefix = (MappingWithPrefix)mapping;
                    return super.visitMapping(new Yaml.Mapping(mappingWithPrefix.getId(), mappingWithPrefix.getMarkers(), mappingWithPrefix.getEntries()), p);
                }
                return super.visitMapping(mapping, p);
            }
        }.visit(y, 0);
    }

    private static class SequenceWithPrefix
    extends Yaml.Sequence {
        private String prefix;

        public SequenceWithPrefix(String prefix, @Nullable String startBracketPrefix, List<Yaml.Sequence.Entry> entries, @Nullable String endBracketPrefix) {
            super(Tree.randomId(), Markers.EMPTY, startBracketPrefix, entries, endBracketPrefix);
            this.prefix = prefix;
        }

        @Override
        public Yaml.Sequence withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }
    }

    private static class MappingWithPrefix
    extends Yaml.Mapping {
        private String prefix;

        public MappingWithPrefix(String prefix, List<Yaml.Mapping.Entry> entries) {
            super(Tree.randomId(), Markers.EMPTY, entries);
            this.prefix = prefix;
        }

        @Override
        public Yaml.Mapping withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }
    }

    private static class SequenceBuilder
    implements BlockBuilder {
        private final String prefix;
        @Nullable
        private final String startBracketPrefix;
        private final List<Yaml.Sequence.Entry> entries = new ArrayList<Yaml.Sequence.Entry>();

        private SequenceBuilder(String prefix, @Nullable String startBracketPrefix) {
            this.prefix = prefix;
            this.startBracketPrefix = startBracketPrefix;
        }

        @Override
        public void push(Yaml.Block block) {
            this.push(block, null);
        }

        public void push(Yaml.Block block, @Nullable String commaPrefix) {
            String blockPrefix;
            String entryPrefix;
            boolean hasDash;
            String rawPrefix = block.getPrefix();
            int dashIndex = YamlParser.commentAwareIndexOf('-', rawPrefix);
            boolean bl = hasDash = dashIndex != -1;
            if (hasDash) {
                entryPrefix = rawPrefix.substring(0, dashIndex);
                blockPrefix = rawPrefix.substring(dashIndex + 1);
            } else {
                entryPrefix = "";
                blockPrefix = rawPrefix;
            }
            this.entries.add(new Yaml.Sequence.Entry(Tree.randomId(), entryPrefix, Markers.EMPTY, block.withPrefix(blockPrefix), hasDash, commaPrefix));
        }

        @Override
        public SequenceWithPrefix build() {
            return new SequenceWithPrefix(this.prefix, this.startBracketPrefix, this.entries, null);
        }
    }

    private static class MappingBuilder
    implements BlockBuilder {
        private final String prefix;
        private final List<Yaml.Mapping.Entry> entries = new ArrayList<Yaml.Mapping.Entry>();
        @Nullable
        private Yaml.Scalar key;

        private MappingBuilder(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public void push(Yaml.Block block) {
            if (this.key == null && block instanceof Yaml.Scalar) {
                this.key = (Yaml.Scalar)block;
            } else {
                String keySuffix = block.getPrefix();
                block = block.withPrefix(keySuffix.substring(YamlParser.commentAwareIndexOf(':', keySuffix) + 1));
                String originalKeyPrefix = this.key.getPrefix();
                this.key = this.key.withPrefix("");
                int entryPrefixStartIndex = Math.max(YamlParser.commentAwareIndexOf('-', originalKeyPrefix), YamlParser.commentAwareIndexOf(':', originalKeyPrefix)) + 1;
                String entryPrefix = originalKeyPrefix.substring(entryPrefixStartIndex);
                String beforeMappingValueIndicator = keySuffix.substring(0, Math.max(YamlParser.commentAwareIndexOf(':', keySuffix), 0));
                this.entries.add(new Yaml.Mapping.Entry(Tree.randomId(), entryPrefix, Markers.EMPTY, this.key, beforeMappingValueIndicator, block));
                this.key = null;
            }
        }

        @Override
        public MappingWithPrefix build() {
            return new MappingWithPrefix(this.prefix, this.entries);
        }
    }

    private static interface BlockBuilder {
        public Yaml.Block build();

        public void push(Yaml.Block var1);
    }
}

