/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.InsertYamlVisitor;
import org.openrewrite.yaml.XPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

@Incubating(since="7.2.0")
public final class InsertYaml
extends Recipe {
    @Option(displayName="Key path", description="XPath expression used to find matching keys.", example="/metadata/labels")
    private final String key;
    @Option(displayName="YAML snippet", description="The YAML snippet to insert. The snippet will be indented to match the style of its surroundings.", example="label-one: \"value-one\"")
    private final String yaml;

    public String getDisplayName() {
        return "Insert YAML snippet";
    }

    public String getDescription() {
        return "Insert a YAML snippet at a given key";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final XPathMatcher xPathMatcher = new XPathMatcher(this.key);
        return new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
                if (InsertYaml.this.key.equals("/")) {
                    this.doAfterVisit(new InsertYamlVisitor(document, InsertYaml.this.yaml));
                    return document;
                }
                return super.visitDocument(document, ctx);
            }

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                if (xPathMatcher.matches(this.getCursor())) {
                    this.doAfterVisit(new InsertYamlVisitor(entry, InsertYaml.this.yaml));
                    return entry;
                }
                return super.visitMappingEntry(entry, ctx);
            }
        };
    }

    public InsertYaml(String key, String yaml) {
        this.key = key;
        this.yaml = yaml;
    }

    public String getKey() {
        return this.key;
    }

    public String getYaml() {
        return this.yaml;
    }

    @NonNull
    public String toString() {
        return "InsertYaml(key=" + this.getKey() + ", yaml=" + this.getYaml() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InsertYaml)) {
            return false;
        }
        InsertYaml other = (InsertYaml)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$yaml = this.getYaml();
        String other$yaml = other.getYaml();
        return !(this$yaml == null ? other$yaml != null : !this$yaml.equals(other$yaml));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof InsertYaml;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $yaml = this.getYaml();
        result = result * 59 + ($yaml == null ? 43 : $yaml.hashCode());
        return result;
    }
}

