/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class CopyValue
extends Recipe {
    @Option(displayName="Old key path", description="A JsonPath expression to locate a YAML key/value pair to copy.", example="$.source.kind")
    private final String oldKeyPath;
    @Option(displayName="New key path", description="A JsonPath expression for where the new value should be copied to.", example="$.dest.kind")
    private final String newKey;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/application-*.yml")
    @Nullable
    @Incubating(since="7.8.0")
    private final String fileMatcher;

    public String getDisplayName() {
        return "Copy YAML value";
    }

    public String getDescription() {
        return "Copies a YAML value from one key to another. The existing key/value pair remains unaffected by this change. If either the source or destination key path does not exist, no value will be copied. Furthermore, copies are limited to scalar values, not whole YAML blocks.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    public YamlVisitor<ExecutionContext> getVisitor() {
        final JsonPathMatcher oldPathMatcher = new JsonPathMatcher(this.oldKeyPath);
        final JsonPathMatcher newPathMatcher = new JsonPathMatcher(this.newKey);
        return new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, final ExecutionContext ctx) {
                Yaml source = super.visitMappingEntry(entry, ctx);
                if (oldPathMatcher.matches(this.getCursor()) && entry.getValue() instanceof Yaml.Scalar) {
                    this.doAfterVisit(new YamlIsoVisitor<ExecutionContext>((Yaml.Mapping.Entry)source){
                        final /* synthetic */ Yaml.Mapping.Entry val$source;
                        {
                            this.val$source = entry;
                        }

                        @Override
                        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext executionContext) {
                            Yaml dest = super.visitMappingEntry(entry, ctx);
                            if (newPathMatcher.matches(this.getCursor())) {
                                dest = ((Yaml.Mapping.Entry)dest).withValue(this.val$source.getValue());
                            }
                            return dest;
                        }
                    });
                }
                return source;
            }
        };
    }

    public CopyValue(String oldKeyPath, String newKey, @Nullable String fileMatcher) {
        this.oldKeyPath = oldKeyPath;
        this.newKey = newKey;
        this.fileMatcher = fileMatcher;
    }

    public String getOldKeyPath() {
        return this.oldKeyPath;
    }

    public String getNewKey() {
        return this.newKey;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "CopyValue(oldKeyPath=" + this.getOldKeyPath() + ", newKey=" + this.getNewKey() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopyValue)) {
            return false;
        }
        CopyValue other = (CopyValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldKeyPath = this.getOldKeyPath();
        String other$oldKeyPath = other.getOldKeyPath();
        if (this$oldKeyPath == null ? other$oldKeyPath != null : !this$oldKeyPath.equals(other$oldKeyPath)) {
            return false;
        }
        String this$newKey = this.getNewKey();
        String other$newKey = other.getNewKey();
        if (this$newKey == null ? other$newKey != null : !this$newKey.equals(other$newKey)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CopyValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldKeyPath = this.getOldKeyPath();
        result = result * 59 + ($oldKeyPath == null ? 43 : $oldKeyPath.hashCode());
        String $newKey = this.getNewKey();
        result = result * 59 + ($newKey == null ? 43 : $newKey.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

