/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;
import org.openrewrite.yaml.FormatPreservingReader;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.Scanner;
import org.yaml.snakeyaml.scanner.ScannerImpl;

public class YamlParser
implements Parser<Yaml.Documents> {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile(":\\s*(@[^\n\r@]+@)");

    public List<Yaml.Documents> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public List<Yaml.Documents> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener();
        return this.acceptedInputs(sourceFiles).stream().map(sourceFile -> {
            Yaml.Documents documents;
            block8: {
                Timer.Builder timer = Timer.builder((String)"rewrite.parse").description("The time spent parsing a YAML file").tag("file.type", "YAML");
                Timer.Sample sample = Timer.start();
                EncodingDetectingInputStream is = sourceFile.getSource();
                try {
                    Yaml.Documents yaml = this.parseFromInput(sourceFile.getRelativePath(relativeTo), is);
                    sample.stop(MetricsHelper.successTags((Timer.Builder)timer).register((MeterRegistry)Metrics.globalRegistry));
                    parsingListener.parsed(sourceFile, (SourceFile)yaml);
                    yaml.withFileAttributes(sourceFile.getFileAttributes());
                    documents = yaml;
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        sample.stop(MetricsHelper.errorTags((Timer.Builder)timer, (Throwable)t).register((MeterRegistry)Metrics.globalRegistry));
                        ctx.getOnError().accept(new IllegalStateException(sourceFile.getPath() + " " + t.getMessage(), t));
                        return null;
                    }
                }
                is.close();
            }
            return documents;
        }).filter(Objects::nonNull).map(this::unwrapPrefixedMappings).map(docs -> {
            if (docs.getDocuments().isEmpty()) {
                return docs.withDocuments(Collections.singletonList(new Yaml.Document(Tree.randomId(), "", Markers.EMPTY, false, new Yaml.Mapping(Tree.randomId(), Markers.EMPTY, null, Collections.emptyList(), null, null), null)));
            }
            return docs;
        }).collect(Collectors.toList());
    }

    private Yaml.Documents parseFromInput(Path sourceFile, EncodingDetectingInputStream source) {
        Yaml.Documents documents;
        String yamlSource = source.readFully();
        HashMap<String, String> variableByUuid = new HashMap<String, String>();
        StringBuilder yamlSourceWithVariablePlaceholders = new StringBuilder();
        Matcher variableMatcher = VARIABLE_PATTERN.matcher(yamlSource);
        int pos = 0;
        while (pos < yamlSource.length() && variableMatcher.find(pos)) {
            yamlSourceWithVariablePlaceholders.append(yamlSource, pos, variableMatcher.start(1));
            String uuid = UUID.randomUUID().toString();
            variableByUuid.put(uuid, variableMatcher.group(1));
            yamlSourceWithVariablePlaceholders.append(uuid);
            pos = variableMatcher.end(1);
        }
        if (pos < yamlSource.length() - 1) {
            yamlSourceWithVariablePlaceholders.append(yamlSource, pos, yamlSource.length());
        }
        FormatPreservingReader reader = new FormatPreservingReader(new InputStreamReader(new ByteArrayInputStream(yamlSourceWithVariablePlaceholders.toString().getBytes(StandardCharsets.UTF_8))));
        try {
            StreamReader streamReader = new StreamReader((Reader)reader);
            ScannerImpl scanner = new ScannerImpl(streamReader);
            ParserImpl parser = new ParserImpl((Scanner)scanner);
            int lastEnd = 0;
            ArrayList<Yaml.Document> documents2 = new ArrayList<Yaml.Document>();
            HashMap<String, Yaml.Anchor> anchors = new HashMap<String, Yaml.Anchor>();
            Yaml.Document document = null;
            Stack<BlockBuilder> blockStack = new Stack<BlockBuilder>();
            String newLine = "";
            Event event = parser.getEvent();
            while (event != null) {
                switch (event.getEventId()) {
                    case DocumentEnd: {
                        String fmt = newLine + reader.prefix(lastEnd, event);
                        newLine = "";
                        assert (document != null);
                        documents2.add(document.withEnd(new Yaml.Document.End(Tree.randomId(), fmt, Markers.EMPTY, ((DocumentEndEvent)event).getExplicit())));
                        lastEnd = event.getEndMark().getIndex();
                        break;
                    }
                    case DocumentStart: {
                        String fmt = newLine + reader.prefix(lastEnd, event);
                        newLine = "";
                        document = new Yaml.Document(Tree.randomId(), fmt, Markers.EMPTY, ((DocumentStartEvent)event).getExplicit(), new Yaml.Mapping(Tree.randomId(), Markers.EMPTY, null, Collections.emptyList(), null, null), null);
                        lastEnd = event.getEndMark().getIndex();
                        break;
                    }
                    case MappingStart: {
                        int startIndex;
                        String fmt = newLine + reader.prefix(lastEnd, event);
                        newLine = "";
                        MappingStartEvent mappingStartEvent = (MappingStartEvent)event;
                        Yaml.Anchor anchor = null;
                        if (mappingStartEvent.getAnchor() != null) {
                            anchor = this.buildYamlAnchor(reader, lastEnd, fmt, mappingStartEvent.getAnchor(), event.getEndMark().getIndex(), false);
                            anchors.put(mappingStartEvent.getAnchor(), anchor);
                            lastEnd = lastEnd + mappingStartEvent.getAnchor().length() + fmt.length() + 1;
                            fmt = reader.readStringFromBuffer(lastEnd, event.getEndMark().getIndex());
                            int dashPrefixIndex = YamlParser.commentAwareIndexOf('-', fmt);
                            if (dashPrefixIndex > -1) {
                                fmt = fmt.substring(0, dashPrefixIndex);
                            }
                        }
                        String fullPrefix = reader.readStringFromBuffer(lastEnd, event.getEndMark().getIndex() - 1);
                        String startBracePrefix = null;
                        int openingBraceIndex = YamlParser.commentAwareIndexOf('{', fullPrefix);
                        if (openingBraceIndex != -1) {
                            startIndex = YamlParser.commentAwareIndexOf(':', fullPrefix) + 1;
                            startBracePrefix = fullPrefix.substring(startIndex, openingBraceIndex);
                            lastEnd = event.getEndMark().getIndex();
                        }
                        blockStack.push(new MappingBuilder(fmt, startBracePrefix, anchor));
                        break;
                    }
                    case Scalar: {
                        BlockBuilder builder;
                        Yaml.Scalar.Style style;
                        String fmt = newLine + reader.prefix(lastEnd, event);
                        newLine = "";
                        ScalarEvent scalar = (ScalarEvent)event;
                        String scalarValue = scalar.getValue();
                        if (variableByUuid.containsKey(scalarValue)) {
                            scalarValue = (String)variableByUuid.get(scalarValue);
                        }
                        Yaml.Anchor anchor = null;
                        if (scalar.getAnchor() != null) {
                            anchor = this.buildYamlAnchor(reader, lastEnd, fmt, scalar.getAnchor(), event.getEndMark().getIndex(), true);
                            anchors.put(scalar.getAnchor(), anchor);
                        }
                        switch (scalar.getScalarStyle()) {
                            case DOUBLE_QUOTED: {
                                style = Yaml.Scalar.Style.DOUBLE_QUOTED;
                                break;
                            }
                            case SINGLE_QUOTED: {
                                style = Yaml.Scalar.Style.SINGLE_QUOTED;
                                break;
                            }
                            case LITERAL: {
                                style = Yaml.Scalar.Style.LITERAL;
                                scalarValue = reader.readStringFromBuffer(event.getStartMark().getIndex() + 1, event.getEndMark().getIndex() - 1);
                                if (!scalarValue.endsWith("\n")) break;
                                newLine = "\n";
                                scalarValue = scalarValue.substring(0, scalarValue.length() - 1);
                                break;
                            }
                            case FOLDED: {
                                style = Yaml.Scalar.Style.FOLDED;
                                scalarValue = reader.readStringFromBuffer(event.getStartMark().getIndex() + 1, event.getEndMark().getIndex() - 1);
                                break;
                            }
                            default: {
                                style = Yaml.Scalar.Style.PLAIN;
                            }
                        }
                        BlockBuilder blockBuilder = builder = blockStack.isEmpty() ? null : (BlockBuilder)blockStack.peek();
                        if (builder instanceof SequenceBuilder) {
                            SequenceBuilder sequenceBuilder = (SequenceBuilder)builder;
                            String betweenEvents = reader.readStringFromBuffer(event.getEndMark().getIndex(), parser.peekEvent().getStartMark().getIndex() - 1);
                            int commaIndex = YamlParser.commentAwareIndexOf(',', betweenEvents);
                            String commaPrefix = null;
                            if (commaIndex != -1) {
                                commaPrefix = betweenEvents.substring(0, commaIndex);
                            }
                            lastEnd = event.getEndMark().getIndex() + commaIndex + 1;
                            sequenceBuilder.push(new Yaml.Scalar(Tree.randomId(), fmt, Markers.EMPTY, style, anchor, scalarValue), commaPrefix);
                            break;
                        }
                        if (builder == null) break;
                        builder.push(new Yaml.Scalar(Tree.randomId(), fmt, Markers.EMPTY, style, anchor, scalarValue));
                        lastEnd = event.getEndMark().getIndex();
                        break;
                    }
                    case SequenceEnd: 
                    case MappingEnd: {
                        Yaml.Mapping map;
                        String s;
                        Yaml.Sequence seq;
                        Yaml.Block mappingOrSequence = ((BlockBuilder)blockStack.pop()).build();
                        if (mappingOrSequence instanceof Yaml.Sequence && (seq = (Yaml.Sequence)mappingOrSequence).getOpeningBracketPrefix() != null) {
                            s = reader.readStringFromBuffer(lastEnd, event.getStartMark().getIndex());
                            int closingBracketIndex = YamlParser.commentAwareIndexOf(']', s);
                            lastEnd = lastEnd + closingBracketIndex + 1;
                            mappingOrSequence = seq.withClosingBracketPrefix(s.substring(0, closingBracketIndex));
                        }
                        if (mappingOrSequence instanceof Yaml.Mapping && (map = (Yaml.Mapping)mappingOrSequence).getOpeningBracePrefix() != null) {
                            s = reader.readStringFromBuffer(lastEnd, event.getStartMark().getIndex());
                            int closingBraceIndex = YamlParser.commentAwareIndexOf('}', s);
                            lastEnd = lastEnd + closingBraceIndex + 1;
                            mappingOrSequence = map.withClosingBracePrefix(s.substring(0, closingBraceIndex));
                        }
                        if (blockStack.isEmpty()) {
                            assert (document != null);
                            document = document.withBlock(mappingOrSequence);
                            break;
                        }
                        ((BlockBuilder)blockStack.peek()).push(mappingOrSequence);
                        break;
                    }
                    case SequenceStart: {
                        int startIndex;
                        String fmt = newLine + reader.prefix(lastEnd, event);
                        newLine = "";
                        SequenceStartEvent sse = (SequenceStartEvent)event;
                        Yaml.Anchor anchor = null;
                        if (sse.getAnchor() != null) {
                            anchor = this.buildYamlAnchor(reader, lastEnd, fmt, sse.getAnchor(), event.getEndMark().getIndex(), false);
                            anchors.put(sse.getAnchor(), anchor);
                            lastEnd = lastEnd + sse.getAnchor().length() + fmt.length() + 1;
                            fmt = reader.readStringFromBuffer(lastEnd, event.getEndMark().getIndex());
                            int dashPrefixIndex = YamlParser.commentAwareIndexOf('-', fmt);
                            if (dashPrefixIndex > -1) {
                                fmt = fmt.substring(0, dashPrefixIndex);
                            }
                        }
                        String fullPrefix = reader.readStringFromBuffer(lastEnd, event.getEndMark().getIndex());
                        String startBracketPrefix = null;
                        int openingBracketIndex = YamlParser.commentAwareIndexOf('[', fullPrefix);
                        if (openingBracketIndex != -1) {
                            startIndex = YamlParser.commentAwareIndexOf(':', fullPrefix) + 1;
                            startBracketPrefix = fullPrefix.substring(startIndex, openingBracketIndex);
                            lastEnd = event.getEndMark().getIndex();
                        }
                        blockStack.push(new SequenceBuilder(fmt, startBracketPrefix, anchor));
                        break;
                    }
                    case Alias: {
                        String fmt = newLine + reader.prefix(lastEnd, event);
                        newLine = "";
                        AliasEvent alias = (AliasEvent)event;
                        Yaml.Anchor anchor = (Yaml.Anchor)anchors.get(alias.getAnchor());
                        BlockBuilder builder = (BlockBuilder)blockStack.peek();
                        builder.push(new Yaml.Alias(Tree.randomId(), fmt, Markers.EMPTY, anchor));
                        lastEnd = event.getEndMark().getIndex();
                        break;
                    }
                    case StreamEnd: {
                        String fmt = newLine + reader.prefix(lastEnd, event);
                        if (document != null || fmt.isEmpty()) break;
                        documents2.add(new Yaml.Document(Tree.randomId(), fmt, Markers.EMPTY, false, new Yaml.Mapping(Tree.randomId(), Markers.EMPTY, null, Collections.emptyList(), null, null), new Yaml.Document.End(Tree.randomId(), "", Markers.EMPTY, false)));
                        break;
                    }
                }
                event = parser.getEvent();
            }
            documents = new Yaml.Documents(Tree.randomId(), Markers.EMPTY, sourceFile, FileAttributes.fromPath((Path)sourceFile), source.getCharset().name(), source.isCharsetBomMarked(), null, documents2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        reader.close();
        return documents;
    }

    private Yaml.Anchor buildYamlAnchor(FormatPreservingReader reader, int lastEnd, String eventPrefix, String anchorKey, int eventEndIndex, boolean isForScalar) {
        int anchorLength = isForScalar ? anchorKey.length() + 1 : anchorKey.length();
        String whitespaceAndScalar = reader.prefix(lastEnd + eventPrefix.length() + anchorLength, eventEndIndex);
        StringBuilder postFix = new StringBuilder();
        for (char c : whitespaceAndScalar.toCharArray()) {
            if (c != ' ' && c != '\t') break;
            postFix.append(c);
        }
        int prefixStart = YamlParser.commentAwareIndexOf(':', eventPrefix);
        String prefix = "";
        if (!isForScalar) {
            prefix = prefixStart > -1 && eventPrefix.length() > prefixStart + 1 ? eventPrefix.substring(prefixStart + 1) : "";
        }
        return new Yaml.Anchor(Tree.randomId(), prefix, postFix.toString(), Markers.EMPTY, anchorKey);
    }

    private static int commentAwareIndexOf(char target, String s) {
        boolean inComment = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (inComment) {
                if (c != '\n') continue;
                inComment = false;
                continue;
            }
            if (c == target) {
                return i;
            }
            if (c != '#') continue;
            inComment = true;
        }
        return -1;
    }

    public boolean accept(Path path) {
        String fileName = path.toString();
        return fileName.endsWith(".yml") || fileName.endsWith(".yaml");
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.yaml");
    }

    private Yaml.Documents unwrapPrefixedMappings(Yaml.Documents y) {
        return (Yaml.Documents)new YamlIsoVisitor<Integer>(){

            @Override
            public Yaml.Sequence visitSequence(Yaml.Sequence sequence, Integer p) {
                if (sequence instanceof SequenceWithPrefix) {
                    SequenceWithPrefix sequenceWithPrefix = (SequenceWithPrefix)sequence;
                    return super.visitSequence(new Yaml.Sequence(sequenceWithPrefix.getId(), sequenceWithPrefix.getMarkers(), sequenceWithPrefix.getOpeningBracketPrefix(), ListUtils.mapFirst(sequenceWithPrefix.getEntries(), e -> e.withPrefix(sequenceWithPrefix.getPrefix())), sequenceWithPrefix.getClosingBracketPrefix(), sequenceWithPrefix.getAnchor()), p);
                }
                return super.visitSequence(sequence, p);
            }

            @Override
            public Yaml.Mapping visitMapping(Yaml.Mapping mapping, Integer p) {
                if (mapping instanceof MappingWithPrefix) {
                    MappingWithPrefix mappingWithPrefix = (MappingWithPrefix)mapping;
                    return super.visitMapping(new Yaml.Mapping(mappingWithPrefix.getId(), mappingWithPrefix.getMarkers(), mappingWithPrefix.getOpeningBracePrefix(), mappingWithPrefix.getEntries(), null, mappingWithPrefix.getAnchor()), p);
                }
                return super.visitMapping(mapping, p);
            }
        }.visit(y, 0);
    }

    private static class MappingBuilder
    implements BlockBuilder {
        private final String prefix;
        @Nullable
        private final String startBracePrefix;
        @Nullable
        private final Yaml.Anchor anchor;
        private final List<Yaml.Mapping.Entry> entries = new ArrayList<Yaml.Mapping.Entry>();
        @Nullable
        private Yaml.Scalar key;

        private MappingBuilder(String prefix, @Nullable String startBracePrefix, @Nullable Yaml.Anchor anchor) {
            this.prefix = prefix;
            this.startBracePrefix = startBracePrefix;
            this.anchor = anchor;
        }

        @Override
        public void push(Yaml.Block block) {
            if (this.key == null && block instanceof Yaml.Scalar) {
                this.key = (Yaml.Scalar)block;
            } else {
                String keySuffix = block.getPrefix();
                block = block.withPrefix(keySuffix.substring(YamlParser.commentAwareIndexOf(':', keySuffix) + 1));
                String originalKeyPrefix = this.key.getPrefix();
                this.key = this.key.withPrefix("");
                int entryPrefixStartIndex = Math.max(YamlParser.commentAwareIndexOf('-', originalKeyPrefix), YamlParser.commentAwareIndexOf(':', originalKeyPrefix)) + 1;
                String entryPrefix = originalKeyPrefix.substring(entryPrefixStartIndex);
                String beforeMappingValueIndicator = keySuffix.substring(0, Math.max(YamlParser.commentAwareIndexOf(':', keySuffix), 0));
                this.entries.add(new Yaml.Mapping.Entry(Tree.randomId(), entryPrefix, Markers.EMPTY, this.key, beforeMappingValueIndicator, block));
                this.key = null;
            }
        }

        @Override
        public MappingWithPrefix build() {
            return new MappingWithPrefix(this.prefix, this.startBracePrefix, this.entries, null, this.anchor);
        }
    }

    private static interface BlockBuilder {
        public Yaml.Block build();

        public void push(Yaml.Block var1);
    }

    private static class SequenceBuilder
    implements BlockBuilder {
        private final String prefix;
        @Nullable
        private final String startBracketPrefix;
        @Nullable
        private final Yaml.Anchor anchor;
        private final List<Yaml.Sequence.Entry> entries = new ArrayList<Yaml.Sequence.Entry>();

        private SequenceBuilder(String prefix, @Nullable String startBracketPrefix, @Nullable Yaml.Anchor anchor) {
            this.prefix = prefix;
            this.startBracketPrefix = startBracketPrefix;
            this.anchor = anchor;
        }

        @Override
        public void push(Yaml.Block block) {
            this.push(block, null);
        }

        public void push(Yaml.Block block, @Nullable String commaPrefix) {
            String blockPrefix;
            String entryPrefix;
            boolean hasDash;
            String rawPrefix = block.getPrefix();
            int dashIndex = YamlParser.commentAwareIndexOf('-', rawPrefix);
            boolean bl = hasDash = dashIndex != -1;
            if (hasDash) {
                entryPrefix = rawPrefix.substring(0, dashIndex);
                blockPrefix = rawPrefix.substring(dashIndex + 1);
            } else {
                entryPrefix = "";
                blockPrefix = rawPrefix;
            }
            this.entries.add(new Yaml.Sequence.Entry(Tree.randomId(), entryPrefix, Markers.EMPTY, block.withPrefix(blockPrefix), hasDash, commaPrefix));
        }

        @Override
        public SequenceWithPrefix build() {
            return new SequenceWithPrefix(this.prefix, this.startBracketPrefix, this.entries, null, this.anchor);
        }
    }

    private static class SequenceWithPrefix
    extends Yaml.Sequence {
        private String prefix;

        public SequenceWithPrefix(String prefix, @Nullable String startBracketPrefix, List<Yaml.Sequence.Entry> entries, @Nullable String endBracketPrefix, @Nullable Yaml.Anchor anchor) {
            super(Tree.randomId(), Markers.EMPTY, startBracketPrefix, entries, endBracketPrefix, anchor);
            this.prefix = prefix;
        }

        @Override
        public Yaml.Sequence withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }
    }

    private static class MappingWithPrefix
    extends Yaml.Mapping {
        private String prefix;

        public MappingWithPrefix(String prefix, @Nullable String startBracePrefix, List<Yaml.Mapping.Entry> entries, @Nullable String endBracePrefix, @Nullable Yaml.Anchor anchor) {
            super(Tree.randomId(), Markers.EMPTY, startBracePrefix, entries, endBracePrefix, anchor);
            this.prefix = prefix;
        }

        @Override
        public Yaml.Mapping withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }
    }
}

